% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge_mining.R
\name{edge_mining}
\alias{edge_mining}
\title{Edge Mining of Gene Interactions Using PubMed}
\usage{
edge_mining(
  predicted_list,
  ground_truth,
  delay = 1,
  query_field = "Title/Abstract",
  query_edge_types = c("TP", "FP", "FN"),
  max_retries = 10,
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{predicted_list}{A list of predicted adjacency matrices (row and
column names are gene symbols), or a \linkS4class{SummarizedExperiment}
object containing adjacency matrices.}

\item{ground_truth}{A 0/1 adjacency matrix with row and column names.}

\item{delay}{Numeric. Seconds to wait between consecutive queries
(default = 1).}

\item{query_field}{Character. PubMed search field. Options:
"Title/Abstract" (default), "Title", "Abstract".}

\item{query_edge_types}{Character vector. Edge types to query:
c("TP", "FP", "FN") (default all).}

\item{max_retries}{Integer. Max retries for PubMed queries
(default = 10).}

\item{BPPARAM}{A BiocParallel parameter object. Default = bpparam().}
}
\value{
A named list of data.frames. Each data.frame has columns:
\describe{
\item{gene1}{First gene in interaction}
\item{gene2}{Second gene}
\item{edge_type}{One of "TP", "FP", or "FN"}
\item{pubmed_hits}{Number of PubMed hits}
\item{PMIDs}{Comma-separated PubMed IDs or NA}
\item{query_status}{One of "hits_found", "no_hits", or "error"}
}
}
\description{
Query PubMed for literature evidence supporting predicted
gene–gene interactions.
}
\details{
This function compares predicted adjacency matrices against a ground truth
matrix, identifies edge types (TP, FP, FN), and queries PubMed for each
gene pair. Returns counts of hits, PMIDs, and query status.
}
\examples{
data(toy_counts)
data(toy_adj_matrix)


# Infer networks (toy_counts is already a MultiAssayExperiment)
networks <- infer_networks(
    count_matrices_list = toy_counts,
    method = "GENIE3",
    nCores = 1
)
head(networks[[1]])

# Generate adjacency matrices
wadj_se <- generate_adjacency(networks)
swadj_se <- symmetrize(wadj_se, weight_function = "mean")

# Apply cutoff
binary_se <- cutoff_adjacency(
    count_matrices = toy_counts,
    weighted_adjm_list = swadj_se,
    n = 1,
    method = "GENIE3",
    quantile_threshold = 0.95,
    nCores = 1,
    debug = TRUE
)
head(binary_se[[1]])

consensus <- create_consensus(binary_se, method = "union")
head(consensus)
em <- edge_mining(consensus, toy_adj_matrix, query_edge_types = "TP")
}
