% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community_path.R
\name{community_path}
\alias{community_path}
\title{Community Detection and Pathway Enrichment Analysis}
\usage{
community_path(
  adj_matrix,
  methods = "louvain",
  pathway_db = "KEGG",
  organism = c("human", "mouse"),
  genes_path = 5,
  plot = TRUE,
  verbose = TRUE,
  method_params = list(),
  comparison_params = list(),
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{adj_matrix}{A square adjacency matrix or a
\linkS4class{SummarizedExperiment} object containing a single adjacency
matrix. Row and column names must correspond to gene symbols.}

\item{methods}{A character vector of one or two community detection
methods supported by \pkg{robin}. If two are given, performance is
compared and the best is selected. Default: \code{"louvain"}.}

\item{pathway_db}{Character string specifying the pathway database to use:
\code{"KEGG"} or \code{"Reactome"}. Default: \code{"KEGG"}.}

\item{organism}{Character string specifying the organism: \code{"human"} or
\code{"mouse"}. Default: \code{"human"}.}

\item{genes_path}{Integer. Minimum number of genes per community to run
enrichment analysis. Default: \code{5}.}

\item{plot}{Logical. If \code{TRUE}, generates a plot of detected
communities. Default: \code{TRUE}.}

\item{verbose}{Logical. If \code{TRUE}, shows progress messages.
Default: \code{TRUE}.}

\item{method_params}{List of parameters for community detection methods.
Common parameters include:
\itemize{
\item \code{resolution}: Resolution parameter for Louvain/Leiden
(default: 1)
\item \code{steps}: Number of steps for Walktrap (default: 4)
\item \code{spins}: Number of spins for Spinglass (default: 25)
\item \code{nb.trials}: Number of trials for Infomap (default: 10)
}}

\item{comparison_params}{List of parameters for robin comparison:
\itemize{
\item \code{measure}: Stability measure ("vi", "nmi", "split.join",
"adjusted.rand"). Default: "vi"
\item \code{type}: Robin construction type ("dependent", "independent").
Default: "independent"
\item \code{rewire.w.type}: Rewiring strategy for weighted graphs.
Default: "Rewire"
}}

\item{BPPARAM}{BiocParallel backend for parallel processing.
Default: \code{BiocParallel::bpparam()}.}
}
\value{
A list with elements:
\itemize{
\item \code{communities}: List with \code{best_method} and a named
vector of community membership per gene.
\item \code{pathways}: List of enrichment results per community
(only for communities meeting size threshold).
\item \code{graph}: The \pkg{igraph} object with community
annotations.
}
}
\description{
Detects gene communities within an adjacency network using one or two
community detection methods, and performs pathway enrichment for each
detected community.
}
\details{
If two methods are provided, the function uses
\code{robinCompare} and selects the method with higher AUC. Pathway
enrichment is done via \pkg{clusterProfiler} (KEGG) or via
\pkg{ReactomePA} (Reactome). Communities smaller than
\code{genes_path} are excluded.
}
\examples{
data(toy_counts)


# Infer networks (toy_counts is already a MultiAssayExperiment)
networks <- infer_networks(
    count_matrices_list = toy_counts,
    method = "GENIE3",
    nCores = 1
)
head(networks[[1]])

# Generate and symmetrize adjacency matrices (returns SummarizedExperiment)
wadj_se <- generate_adjacency(networks)
swadj_se <- symmetrize(wadj_se, weight_function = "mean")

# Apply cutoff (returns SummarizedExperiment)
binary_se <- cutoff_adjacency(
    count_matrices = toy_counts,
    weighted_adjm_list = swadj_se,
    n = 1,
    method = "GENIE3",
    quantile_threshold = 0.95,
    nCores = 1,
    debug = TRUE
)

# Create consensus (returns SummarizedExperiment)
consensus <- create_consensus(binary_se, method = "union")

# community_path now accepts SummarizedExperiment objects directly
comm_cons <- community_path(consensus)

}
