% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCzinb_internal.R
\name{PCzinb}
\alias{PCzinb}
\title{Structure learning for count data using PC algorithms}
\usage{
PCzinb(
  x,
  method = c("poi", "nb", "zinb0", "zinb1"),
  alpha = NULL,
  maxcard = 2,
  extend = TRUE,
  nCores = 1,
  whichAssay = "processed",
  ...
)
}
\arguments{
\item{x}{A matrix of count data (n × p), SummarizedExperiment, or
SingleCellExperiment object. For matrix input, rows are samples and
columns are genes.}

\item{method}{The algorithm used to estimate the graph: \code{poi} (Poisson),
\code{nb} (Negative Binomial), \code{zinb0} (Zero-Inflated NB with structure only
in mu), or \code{zinb1} (Zero-Inflated NB with structure in both mu and pi).}

\item{alpha}{The significance level of the tests. Default:
2 * pnorm(nrow(x)^0.2, lower.tail = FALSE).}

\item{maxcard}{The upper bound of the cardinality of the conditional sets K.
Default: 2.}

\item{extend}{If TRUE, considers the union of the tests; if FALSE, considers
the intersection. Default: TRUE.}

\item{nCores}{Number of cores for parallel processing. Default: 1.}

\item{whichAssay}{The assay to use as input (for SummarizedExperiment or
SingleCellExperiment objects). Default: "processed".}

\item{...}{Additional arguments (currently unused).}
}
\value{
\itemize{
\item If x is a matrix: the estimated adjacency matrix of the graph
\item If x is a SummarizedExperiment: the object with adjacency matrix
stored in metadata as \code{adj_mat}
\item If x is a SingleCellExperiment: the object with adjacency matrix
stored as rowPair
}
}
\description{
This function performs structure learning for count data using various
PC algorithms adapted for different distributional assumptions including
Poisson, Negative Binomial, and Zero-Inflated Negative Binomial models.
}
\details{
PCzinb performs structure learning using PC algorithms for count data.
Different methods handle different distributional assumptions:
\itemize{
\item \code{poi}: Poisson distribution
\item \code{nb}: Negative Binomial distribution
\item \code{zinb0}: Zero-Inflated NB with structure only in mean parameter
\item \code{zinb1}: Zero-Inflated NB with structure in both mean and
zero-inflation parameters
}

For SummarizedExperiment and SingleCellExperiment inputs, if the specified
\code{whichAssay} is "processed" but not found, the function will use the first
assay and issue a warning recommending QPtransform().
}
\examples{
# Matrix input
mat <- matrix(rpois(50, 5), nrow = 10)
PCzinb(mat, method = "poi")

# SummarizedExperiment input
library(SummarizedExperiment)
se <- SummarizedExperiment(matrix(rpois(50, 5), ncol = 10))
se_result <- PCzinb(se, method = "poi")

# SingleCellExperiment input
library(SingleCellExperiment)
sce <- SingleCellExperiment(matrix(rpois(50, 5), ncol = 10))
sce_result <- PCzinb(sce, method = "poi")
rowPair(sce_result)
}
