% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projectSIR.R
\name{projectSIR}
\alias{projectSIR}
\title{Project Query Data Onto SIR Space of Reference Data}
\usage{
projectSIR(
  query_data,
  reference_data,
  query_cell_type_col,
  ref_cell_type_col,
  cell_types = NULL,
  multiple_cond_means = TRUE,
  cumulative_variance_threshold = 0.7,
  n_neighbor = 1,
  assay_name = "logcounts",
  max_cells_query = 5000,
  max_cells_ref = 5000
)
}
\arguments{
\item{query_data}{A \code{\linkS4class{SingleCellExperiment}} object containing numeric expression matrix for the query cells.}

\item{reference_data}{A \code{\linkS4class{SingleCellExperiment}} object containing numeric expression matrix for the reference cells.}

\item{query_cell_type_col}{A character string specifying the column in the \code{colData} of \code{query_data}
that identifies the cell types.}

\item{ref_cell_type_col}{A character string specifying the column in the \code{colData} of \code{reference_data}
that identifies the cell types.}

\item{cell_types}{A character vector of cell types for which to compute conditional means in the reference data.}

\item{multiple_cond_means}{A logical value indicating whether to compute multiple conditional means per cell type
(through PCA and clustering). Defaults to \code{TRUE}.}

\item{cumulative_variance_threshold}{A numeric value between 0 and 1 specifying the variance threshold for PCA
when computing multiple conditional means. Defaults to \code{0.7}.}

\item{n_neighbor}{An integer specifying the number of nearest neighbors for clustering when computing multiple
conditional means. Defaults to \code{1}.}

\item{assay_name}{A character string specifying the assay name on which to perform computations. Defaults to \code{"logcounts"}.}

\item{max_cells_query}{Maximum number of query cells to retain after cell type filtering. If NULL,
no downsampling of query cells is performed. Default is 5000.}

\item{max_cells_ref}{Maximum number of reference cells to retain after cell type filtering. If NULL,
no downsampling of reference cells is performed. Default is 5000.}
}
\value{
A list containing:
\item{cond_means}{A matrix of the conditional means computed for the reference data.}
\item{rotation_mat}{The rotation matrix obtained from the SVD of the conditional means.}
\item{sir_projections}{A \code{data.frame} containing the SIR projections for both the reference and query datasets.}
\item{percent_var}{The percentage of variance explained by each component of the SIR projection.}
}
\description{
This function projects a query \code{SingleCellExperiment} object onto the SIR (supervised independent
component) space of a reference \code{SingleCellExperiment} object. The SVD of the reference data is
computed on conditional means per cell type, and the query data is projected based on these reference
components.
}
\details{
The genes used for the projection (SVD) must be present in both the reference and query datasets.
The function first computes conditional means for each cell type in the reference data, then performs
SVD on these conditional means to obtain the rotation matrix used for projecting both the reference
and query datasets. The query data is centered and scaled based on the reference data.
}
\examples{
# Load data
data("reference_data")
data("query_data")

# Project the query data onto SIR space of reference
sir_output <- projectSIR(query_data = query_data,
                         reference_data = reference_data,
                         query_cell_type_col = "SingleR_annotation",
                         ref_cell_type_col = "expert_annotation")

}
\author{
Anthony Christidis, \email{anthony-alexander_christidis@hms.harvard.edu}
}
