% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markerExpression.R
\name{markerExpression}
\alias{markerExpression}
\title{Highlight the individual marker expression profile across a 2-dimensional reduction / embedding, typically contained within a \code{SingleCellExperiment} object. By default, this function plots the expression profile of 6 randomly-selected markers from your data.}
\usage{
markerExpression(
  indata,
  layout = NULL,
  assay = "scaled",
  reducedDim = "UMAP",
  dimColnames = c("UMAP1", "UMAP2"),
  markers = sample(rownames(indata), 6),
  ncol = 3,
  nrow = 2,
  col = c("darkblue", "yellow"),
  colMidpoint = 0,
  alpha = c(0, 1),
  pointSize = 0.5,
  legendPosition = "right",
  legendLabSize = 12,
  legendKeyHeight = 2.5,
  xlim = NULL,
  ylim = NULL,
  celllab = NULL,
  labSize = 3,
  drawConnectors = TRUE,
  widthConnectors = 0.5,
  colConnectors = "black",
  xlab = dimColnames[1],
  xlabAngle = 0,
  xlabhjust = 0.5,
  xlabvjust = 0.5,
  ylab = dimColnames[2],
  ylabAngle = 0,
  ylabhjust = 0.5,
  ylabvjust = 0.5,
  axisLabSize = 16,
  stripLabSize = 16,
  title = "Individual marker expression",
  subtitle = "",
  caption = ifelse(is(indata, "SingleCellExperiment"), paste0("Total cells, ",
    nrow(as.data.frame(reducedDim(indata, reducedDim)))), paste0("Total cells, ",
    nrow(layout))),
  titleLabSize = 16,
  subtitleLabSize = 12,
  captionLabSize = 12,
  hline = NULL,
  hlineType = "longdash",
  hlineCol = "black",
  hlineWidth = 0.4,
  vline = NULL,
  vlineType = "longdash",
  vlineCol = "black",
  vlineWidth = 0.4,
  gridlines.major = TRUE,
  gridlines.minor = TRUE,
  borderWidth = 0.8,
  borderColour = "black"
)
}
\arguments{
\item{indata}{A data-frame or matrix, or \code{SingleCellExperiment} object. If a
data-frame or matrix, this should relate to expression data (cells as
columns; genes as rows). If a \code{SingleCellExperiment} object, data will be
extracted from an assay component named by \code{assay}.}

\item{layout}{If 'indata' is a non-SingleCellExperiment object, \code{layout} must
be activated and relate to a 2-dimensional reduction / embedding, although,
technically, any data-frame or matrix of numbers will be accepted, provided
that it aligns with the dimensions of \code{indata}, and provided that it
contains columns as specified in \code{dimColnames}.}

\item{assay}{Name of the assay slot in 'indata' from which data will be
taken, assuming \code{indata} is a \code{SingleCellExperiment} object.}

\item{reducedDim}{A reduced dimensional component stored within \code{indata},
e.g., PCA or UMAP.}

\item{dimColnames}{The column names of the dimensions to use.}

\item{markers}{Vector containing marker names to plot.}

\item{ncol}{Number of columns for faceting.}

\item{nrow}{Number of rows for faceting.}

\item{col}{Colours used for generation of fill gradient according to
expression values. Can be 2 or 3 colours.}

\item{colMidpoint}{Mid-point (expression value) for the colour range. Only
used when 3 colours are specified by \code{col}.}

\item{alpha}{Control the gradient of colour transparency, with 1 being opaque.}

\item{pointSize}{Size of plotted points.}

\item{legendPosition}{Position of legend \code{('top', 'bottom', 'left', 'right',
'none')}.}

\item{legendLabSize}{Size of plot legend text.}

\item{legendKeyHeight}{Height of the legend key.}

\item{xlim}{Limits of the x-axis.}

\item{ylim}{Limits of the y-axis.}

\item{celllab}{A vector containing any cells that the user wishes to label
in the plot.}

\item{labSize}{Size of labels.}

\item{drawConnectors}{Logical, indicating whether or not to connect plot
labels to their corresponding points by line connectors.}

\item{widthConnectors}{Line width of connectors.}

\item{colConnectors}{Line colour of connectors.}

\item{xlab}{Label for x-axis.}

\item{xlabAngle}{Rotation angle of x-axis labels.}

\item{xlabhjust}{Horizontal adjustment of x-axis labels.}

\item{xlabvjust}{Vertical adjustment of x-axis labels.}

\item{ylab}{Label for y-axis.}

\item{ylabAngle}{Rotation angle of y-axis labels.}

\item{ylabhjust}{Horizontal adjustment of y-axis labels.}

\item{ylabvjust}{Vertical adjustment of y-axis labels.}

\item{axisLabSize}{Size of x- and y-axis labels.}

\item{stripLabSize}{Size of the strip (marker) labels.}

\item{title}{Plot title.}

\item{subtitle}{Plot subtitle.}

\item{caption}{Plot caption.}

\item{titleLabSize}{Size of plot title.}

\item{subtitleLabSize}{Size of plot subtitle.}

\item{captionLabSize}{Size of plot caption.}

\item{hline}{Draw one or more horizontal lines passing through this/these
 values on y-axis. For single values, only a single numerical value is
necessary. For multiple lines, pass these as a vector, e.g., c(60,90).}

\item{hlineType}{Line type for hline \code{('blank', 'solid', 'dashed', 'dotted',
'dotdash', 'longdash', 'twodash')}.}

\item{hlineCol}{Colour of hline.}

\item{hlineWidth}{Width of hline.}

\item{vline}{Draw one or more vertical lines passing through this/these
values on x-axis. For single values, only a single numerical value is
necessary. For multiple lines, pass these as a vector, e.g., c(60,90).}

\item{vlineType}{Line type for vline \code{('blank', 'solid', 'dashed', 'dotted',
'dotdash', 'longdash', 'twodash')}.}

\item{vlineCol}{Colour of vline.}

\item{vlineWidth}{Width of vline.}

\item{gridlines.major}{Logical, indicating whether or not to draw major
gridlines.}

\item{gridlines.minor}{Logical, indicating whether or not to draw minor
gridlines.}

\item{borderWidth}{Width of the border on the x and y axes.}

\item{borderColour}{Colour of the border on the x and y axes.}
}
\value{
A \code{ggplot2} object.
}
\description{
Highlight the individual marker expression profile across a 2-dimensional reduction / embedding, typically contained within a \code{SingleCellExperiment} object. By default, this function plots the expression profile of 6 randomly-selected markers from your data.
}
\details{
Highlight the individual marker expression profile across a 2-dimensional reduction / embedding, typically contained within a \code{SingleCellExperiment} object. By default, this function plots the expression profile of 6 randomly-selected markers from your data.
}
\examples{
# create random data that follows a negative binomial
mat <- jitter(matrix(
MASS::rnegbin(rexp(1000, rate=.1), theta = 4.5),
  ncol = 20))
colnames(mat) <- paste0('CD', 1:ncol(mat))
rownames(mat) <- paste0('cell', 1:nrow(mat))

u <- umap::umap(mat)$layout
colnames(u) <- c('UMAP1','UMAP2')
rownames(u) <- rownames(mat)

markerExpression(t(mat), layout = u)

}
\author{
Kevin Blighe <kevin@clinicalbioinformatics.co.uk>
}
