% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read10xRaw.R
\name{Read10xRaw}
\alias{Read10xRaw}
\alias{Read10xRawH5}
\title{Read 10x output data}
\usage{
Read10xRaw(dir = NULL, row.name = "symbol", meta = FALSE)

Read10xRawH5(h5file, row.name = "symbol", meta = FALSE)
}
\arguments{
\item{dir}{The directory of 10x output data. For Cell Ranger version <3,
directory should include three files: barcodes.tsv, genes.tsv, matrix.mtx.
For Cell Ranger version >=3, directory should include three
files: barcodes.tsv.gz, features.tsv.gz, matrix.mtx.gz.}

\item{row.name}{Specify either using gene symbols 
(\code{row.name = "symbol"}) or gene Ensembl IDs (\code{row.name = "id"})
as row names of the count matrix. Default is \code{row.name = "symbol"}.}

\item{meta}{Logical. If \code{TRUE}, returns a list containing both the 
count matrix and metadata of genes (features). Metadata includes feature 
names, IDs and other additional information depending on Cell Ranger 
output. If \code{FALSE} (default), only returns the count matrix.}

\item{h5file}{The path of 10x output HDF5 file (ended with .h5).}
}
\value{
If \code{meta = TRUE}, returns a list of two elements: a 
"dgCMatrix" sparse matrix containing expression counts and a data 
frame containing metadata of genes (features). For the count matrix, 
each row is a gene (feature) and each column is a barcode.  If 
\code{meta = FALSE}, only returns the count matrix.
}
\description{
\code{Read10xRaw} is a one-line handy function for reading 
10x Cell Ranger output data, producing a count matrix for input to 
\code{CB2FindCell}. \code{Read10xRawH5} is for reading 10x Cell Ranger output
HDF5 file (ended with .h5).  Works under both old (<3) and new (>=3) 
Cell Ranger version.
}
\examples{

# simulate 10x output files
data(mbrainSub)
data_dir <- file.path(tempdir(),"CB2example")
dir.create(data_dir)
gene_name <- rownames(mbrainSub)

# For simplicity, use gene names to generate gene IDs to fit the format.
gene_id <- paste0("ENSG_fake_",gene_name)
barcode_id <- colnames(mbrainSub)
Matrix::writeMM(mbrainSub,file = file.path(data_dir,"matrix.mtx"))
write.table(barcode_id,file = file.path(data_dir,"barcodes.tsv"),
    sep = "\t", quote = FALSE, col.names = FALSE, row.names = FALSE)
write.table(cbind(gene_id,gene_name),file = file.path(data_dir,"genes.tsv"),
    sep = "\t", quote = FALSE, col.names = FALSE, row.names = FALSE)

# read files
list.files(data_dir)
mbrainSub_new <- Read10xRaw(data_dir)
str(mbrainSub_new)
identical(mbrainSub, mbrainSub_new)

}
