% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{scAnnotatR}
\alias{scAnnotatR}
\title{scAnnotatR class.}
\usage{
scAnnotatR(cell_type, caret_model, marker_genes, p_thres, parent)

scAnnotatR(cell_type, caret_model, marker_genes, p_thres, parent)
}
\arguments{
\item{cell_type}{character. Name of the cell type.}

\item{caret_model}{list. Trained model returned by caret train function.}

\item{marker_genes}{vector/character containing marker genes used for the training.}

\item{p_thres}{numeric. 
Probability threshold for the cell type to be assigned for a cell.}

\item{parent}{character. Parent cell type.}
}
\value{
A scAnnotatR object.
}
\description{
This class is returned by the \code{\link{train_classifier}} function.
Generally, scAnnotatR objects are never created directly.
}
\section{Slots}{

\describe{
\item{\code{cell_type}}{character. Name of the cell type.}

\item{\code{caret_model}}{list. Trained model returned by caret train function.}

\item{\code{marker_genes}}{vector/character containing marker genes 
used for the training.}

\item{\code{p_thres}}{numeric. 
Probability threshold for the cell type to be assigned for a cell.}

\item{\code{parent}}{character. Parent cell type.}
}}

\examples{
# load small example dataset
data("tirosh_mel80_example")

# train a classifier, for ex: B cell
selected_marker_genes_B = c("CD19", "MS4A1", "CD79A")
set.seed(123)
classifier_b <- train_classifier(train_obj = tirosh_mel80_example,
assay = 'RNA', slot = 'counts', marker_genes = selected_marker_genes_B, 
cell_type = "B cells", tag_slot = 'active.ident')

classifier_b
}
