% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{delete_model}
\alias{delete_model}
\title{Delete model/branch from package}
\usage{
delete_model(cell_type, path_to_models = tempdir())
}
\arguments{
\item{cell_type}{string indicating the cell type of which 
the model will be removed from package
Attention: deletion of a parent model will also delete all of child model.}

\item{path_to_models}{path to the folder containing 
the list of models in which the to-be-deleted model is.}
}
\value{
no return value, but the model is deleted from database
}
\description{
Delete model/branch from package
}
\examples{
# load small example dataset
data("tirosh_mel80_example")

# train a classifier
set.seed(123)
selected_marker_genes_T = c("CD4", "CD8A", "CD8B")
classifier_t <- train_classifier(train_obj = tirosh_mel80_example,
assay = 'RNA', slot = 'counts', marker_genes = selected_marker_genes_T, 
cell_type = "t cells", tag_slot = 'active.ident')

# save a classifier to system
save_new_model(new_model = classifier_t, path_to_models = tempdir(), 
               include.default = FALSE)

# delete classifier from system
delete_model("t cells", path_to_models = tempdir())
}
