% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/sangerseqmethods.R
\name{chromatogram}
\alias{chromatogram}
\alias{chromatogram,sangerseq-method}
\title{Generate Chromatogram}
\usage{
chromatogram(
  obj,
  trim5 = 0,
  trim3 = 0,
  showcalls = c("primary", "secondary", "both", "none"),
  width = 500,
  height = NA,
  cex.mtext = 1,
  cex.base = 1,
  ylim = 2,
  filename = NULL,
  showtrim = FALSE,
  showhets = TRUE
)

\S4method{chromatogram}{sangerseq}(
  obj,
  trim5 = 0,
  trim3 = 0,
  showcalls = c("primary", "secondary", "both", "none"),
  width = 100,
  height = 2,
  cex.mtext = 1,
  cex.base = 1,
  ylim = 3,
  filename = NULL,
  showtrim = FALSE,
  showhets = TRUE
)
}
\arguments{
\item{obj}{\code{\link{sangerseq}} class object}

\item{trim5}{Number of bases to trim from the beginning of the sequence.}

\item{trim3}{Number of bases to trim from the end of the sequence.}

\item{showcalls}{Which basecall sequence to show. Any value other than
"primary", "secondary" or "both" will result in basecalls not being shown.}

\item{width}{Approximate number of bases per line.}

\item{height}{Height of each plot row. Ignored by some devices.}

\item{cex.mtext}{Size factor for the text in the margins.}

\item{cex.base}{Size factor for the basecall text.}

\item{ylim}{Peaks larger than this many times the IQR larger than the median
will be cutoff.}

\item{filename}{Name of PDF file to save to. A "NULL" value outputs the
chromatogram to the current device.}

\item{showtrim}{If true, highlights trimmed region instead of hiding it.}

\item{showhets}{Whether or not to highlight heterozygous positions.}
}
\value{
A plot showing the chromatogram tracedata and, optionally, basecalls.
}
\description{
Generates a chromatogram from a \code{\link{sangerseq}} class object.
}
\details{
This function outputs a chromatogram to the current device or to a PDF file 
(filename is not NULL). Primary, Secondary or both basecalls can be shown if 
they are contained in the \code{\link{sangerseq}} object provided. What is 
shown will depend on how they were generated. If generated and provided by 
the ABIF or SCF file, then it will show the primary calls on the first line 
and the secondary calls on the second line. If generated by 
\code{\link{makeBaseCalls}}, then they will show the maximum and alternate 
basecalls only for heterozygous peaks. Finally, if the 
\code{\link{setAllelePhase}} has been run on the object, then the first line 
is the reference sequence and the second line is the alternate allele.

The range of the trace data shown is trimmed to the called sequence by
default. Setting \code{trim5} and \code{trim3} to NULL will show the complete
trace 5' and 3' of the called bases, respectively. This will generally create
a very long trace. Conversely, setting \code{trim5} and \code{trim3} to an
integer > 0 will hide the data corresponding to that number of bases at each
end. For example, \code{trim5=10} and \code{trim3=20} will remove 10 bases
from the 5' end and 20 bases from the 3' end.

Several output parameters can also be set to control how the figure appears.
However, it should be noted that if the current device is too small, R will
return an error and not show the chromatogram. This is common with long
sequence reads. To bypass this error, we recommend that the user set
\code{filename}. This will cause the chromatogram to be saved to a PDF file
in the current working directory.
}
\examples{
hetsangerseq <- readsangerseq(system.file("extdata", 
                                          "heterozygous.ab1", 
                                          package = "sangerseqR"))
hetcalls <- makeBaseCalls(hetsangerseq, ratio = 0.33)
chromatogram(hetcalls, width = 100, height = 2, trim5 = 50, trim3 = 100, 
             showcalls = "both", filename = "chromatogram.pdf")

}
\seealso{
\code{\link{makeBaseCalls}}, \code{\link{setAllelePhase}}, 
\code{\link{sangerseq}}
}
