% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\name{sracipeIC<-}
\alias{sracipeIC<-}
\alias{sracipeIC<-,RacipeSE-method}
\alias{sracipeIC-set}
\title{A method to set the initial conditions}
\usage{
sracipeIC(.object) <- value

\S4method{sracipeIC}{RacipeSE}(.object) <- value
}
\arguments{
\item{.object}{RacipeSE object}

\item{value}{DataFrame containing the initial conditions, dimensions should
be (# genes) rows by (numModels*nIC) columns}
}
\value{
A RacipeSE object
}
\description{
Set the initial conditions
}
\examples{
data("demoCircuit")
rSet <- sRACIPE::sracipeSimulate(circuit = demoCircuit, numModels = 10,
integrate=FALSE)
ics <- sracipeIC(rSet)
sracipeIC(rSet) <- ics
rm(rSet, ics)
}
