% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sRACIPE.R
\docType{package}
\name{sRACIPE}
\alias{sRACIPE-package}
\alias{sRACIPE}
\title{sRACIPE: A package for stochastic random circuit perturbation.}
\description{
sRACIPE is a systems biology tool to study the role of noise and parameter
variation in gene regulatory circuits. It implements a randomization-based
method for gene circuit modeling. It allows us to study the effect of both
the gene expression noise and the parametric variation on any
gene regulatory circuit (GRC) using only its topology, and simulates an
ensemble of models with random kinetic parameters at multiple noise levels.
Statistical analysis of the generated gene expressions reveals the basin of
attraction and stability of various phenotypic states and their changes
associated with intrinsic and extrinsic noises. sRACIPE provides a holistic
picture to evaluate the effects of both the stochastic nature of cellular
processes and the parametric variation.
}
\section{sRACIPE functions}{


\code{\link{sracipeSimulate}}
Primary function to simulate a circuit.
 Contains options for plotting as well.
\code{\link{sracipeKnockDown}}
In-silico knockdown analysis of the circuit. Plots the relative changes in
different cluster proportions.

\code{\link{sracipeOverExp}}
In-silico over expression analysis of the circuit.
Plots the relative changes in
different cluster proportions.

\code{\link{sracipePlotData}}
Plot the simulated data. Includes options to plot the hierarchichal
clustering analysis, principal components, and uniform manifold
approximation and projection. Can plot the stochastic as well as the
knockout simulations.

\code{\link{sracipeSimulate}},  \code{\link{sracipeKnockDown}},
\code{\link{sracipeOverExp}},  \code{\link{sracipePlotData}}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/lusystemsbio/sRACIPE}
  \item \url{https://geneex.jax.org/}
  \item \url{https://vivekkohar.github.io/sRACIPE/}
}

}
\author{
\strong{Maintainer}: Mingyang Lu \email{m.lu@northeastern.edu} (\href{https://orcid.org/0000-0001-8158-0593}{ORCID})

Authors:
\itemize{
  \item Vivek Kohar
  \item Aidan Tillman
  \item Daniel Ramirez
}

}
