% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{make_edge_weights}
\alias{make_edge_weights}
\title{Create edge weights}
\usage{
make_edge_weights(
    graph,
    e_feat,
    node_semtypes_out = NULL,
    node_names_out = NULL,
    edge_preds_out = NULL,
    node_semtypes_in = NULL,
    node_names_in = NULL,
    edge_preds_in = NULL
)
}
\arguments{
\item{graph}{The SemMed graph}

\item{e_feat}{A \code{data.frame} of edge features from 
\code{get_edge_features}.}

\item{node_semtypes_out}{A character vector of semantic types to exclude 
from shortest paths.}

\item{node_names_out}{A character vector of exact node names to exclude.}

\item{edge_preds_out}{A character vector of edge predicates to exclude.}

\item{node_semtypes_in}{A character vector of semantic types to 
include/encourage in shortest paths.}

\item{node_names_in}{A character vector of exact node names to include.}

\item{edge_preds_in}{A character vector of edge predicates to include.}
}
\value{
A numeric vector of weights
}
\description{
Create edge weights to modify the shortest path search 
(\code{find_paths}). Discourage and/or encourage certain types of paths 
by supplying \code{_out} and \code{_in} arguments, respectively. Node 
semantic types, node names, and edge predicates are the features that 
can influence the edge weights. Capitalization is ignored.
}
\examples{
data(g_mini)

node_cortisol <- find_nodes(g_mini, names = "Serum cortisol")
node_stress <- find_nodes(g_mini, names = "Chronic Stress")
paths <- find_paths(g_mini, from = node_cortisol, to = node_stress)

e_feat <- get_edge_features(g_mini)

w1 <- make_edge_weights(g_mini, e_feat, edge_preds_in = "COEXISTS_WITH")
paths1 <- find_paths(g_mini,
    from = node_cortisol, to = node_stress, weights = w1)

w2 <- make_edge_weights(g_mini, e_feat, edge_preds_in = "ISA",
                        node_names_out = "Stress")
paths2 <- find_paths(g_mini,
    from = node_cortisol, to = node_stress, weights = w2)

}
\seealso{
\code{\link{find_paths}}, \code{\link{get_middle_nodes}} for a 
way to obtain node names to remove
}
