% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqt-generics.R, R/rqt-methods.R
\docType{methods}
\name{results}
\alias{results}
\alias{results,rqt-method}
\title{This function performs an access to covariates}
\usage{
results(obj)

\S4method{results}{rqt}(obj)
}
\arguments{
\item{obj}{An object of \code{rqt} class.}
}
\value{
results returns the results
}
\description{
An accessor to results
}
\examples{
data <- data.matrix(read.table(system.file("extdata/test.bin1.dat", 
package="rqt"), header=TRUE))
pheno <- data[,1]
geno <- data[, 2:dim(data)[2]]
colnames(geno) <- paste(seq(1, dim(geno)[2]))
geno.obj <- SummarizedExperiment(geno)
obj <- rqt(phenotype=pheno, genotype=geno.obj)
res <- geneTest(obj, method="pca", out.type = "D")
results(res)
}
