% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/designOligos.R
\name{designOligos}
\alias{designOligos}
\title{Design primers and probes}
\usage{
designOligos(
  x,
  maxGapFrequency = 0.01,
  lengthPrimer = c(18, 22),
  maxDegeneracyPrimer = 4,
  gcClampPrimer = TRUE,
  avoidThreeEndRunsPrimer = TRUE,
  gcPrimer = c(0.4, 0.65),
  tmPrimer = c(50, 65),
  concPrimer = 500,
  designStrategyPrimer = "ambiguous",
  probe = TRUE,
  lengthProbe = c(18, 22),
  maxDegeneracyProbe = 4,
  avoidFiveEndGProbe = TRUE,
  gcProbe = c(0.4, 0.65),
  tmProbe = c(50, 70),
  concProbe = 250,
  concNa = 0.05
)
}
\arguments{
\item{x}{An \code{RprimerProfile} object.}

\item{maxGapFrequency}{Maximum allowed gap frequency at the primer and probe binding sites in
the target alignment.
A number [0, 1], defaults to \code{0.01}.}

\item{lengthPrimer}{Primer length range. A numeric vector [15, 30],
defaults to \code{c(18, 22)}.}

\item{maxDegeneracyPrimer}{Maximum number of variants of each primer. A number [1, 64],
defaults to \code{4}.}

\item{gcClampPrimer}{If primers must have a GC clamp.
A GC clamp
is identified as two to three G or
C:s within the last five bases (3' end) of the primer.
\code{TRUE} or \code{FALSE}, defaults to \code{TRUE}.}

\item{avoidThreeEndRunsPrimer}{If primers with more than two runs
of the same nucleotide at the terminal 3' end should be avoided.
\code{TRUE} or \code{FALSE}, defaults to \code{TRUE}.}

\item{gcPrimer}{GC-content range for primers.
A numeric vector [0, 1], defaults to \code{c(0.40, 0.65)}.}

\item{tmPrimer}{Tm range for primers (in Celcius degrees).
A numeric vector [30, 90], defaults to \code{c(55, 65)}.}

\item{concPrimer}{Primer concentration in nM, for tm calculation. A number
[20, 2000], defaults to \code{500}.}

\item{designStrategyPrimer}{\code{"ambiguous"} or \code{"mixed"}. Defaults to \code{"ambiguous"}
(see details below).}

\item{probe}{If probes should be designed. \code{TRUE} or \code{FALSE},
defaults to \code{TRUE}.}

\item{lengthProbe}{Probe length range. A numeric vector [15, 40],
defaults to \code{c(18, 22)}.}

\item{maxDegeneracyProbe}{Maximum number of variants of each probe. A number [1, 64],
defaults to \code{4}.}

\item{avoidFiveEndGProbe}{If probes with G
at the 5' end should be avoided. \code{TRUE} or \code{FALSE},
defaults to \code{TRUE}.}

\item{gcProbe}{GC-content range for probes. A numeric vector [0, 1],
defaults to \code{c(0.40, 0.65)}.}

\item{tmProbe}{Tm range for probes (in Celcius degrees).
A numeric vector [30, 90], defaults to \code{c(55, 70)}.}

\item{concProbe}{Primer concentration in nM, for tm calculation. A numeric vector
[20, 2000], defaults to \code{250}.}

\item{concNa}{Sodium ion (equivalent) concentration in the PCR reaction (in M).
For calculation of tm and delta G.
A numeric vector [0.01, 1], defaults to \code{0.05} (50 mM).}
}
\value{
An \code{RprimerOligo} object, containing the following information:

\describe{
  \item{type}{Whether the oligo is a primer or probe.}
  \item{fwd}{\code{TRUE} if the oligo is valid in forward direction,
    \code{FALSE} otherwise.}
  \item{rev}{\code{TRUE} if the oligo is valid in reverse direction,
    \code{FALSE} otherwise.}
  \item{start}{Start position of the oligo.}
  \item{end}{End positon of the oligo.}
  \item{length}{Oligo length.}
  \item{iupacSequence}{Oligo sequence in IUPAC format
  (i.e. with ambiguous bases).}
  \item{iupaSequenceRc}{The reverse complement of the iupacSequence.}
  \item{identity}{For ambiguous oligos: average identity of the oligo.
    For mixed oligos: average identity of the 5' (consensus) part of the
    oligo. The value can range from 0 to 1.}
  \item{coverage}{For ambiguous oligos: average coverage of the oligo.
    For mixed oligos: average coverage of the 3' (degenerate) part of the
    oligo. The value can range from 0 to 1.}
  \item{degeneracy}{Number of sequence variants of the oligo.}
  \item{gcContentMean}{Mean GC-content of all sequence variants of the oligo.
  }
  \item{gcContent}{Range in GC-content of all sequence variants of
    the oligo.}
  \item{tmMean}{Mean tm of all sequence variants of the oligo
  (in Celcius degrees).}
  \item{tm}{Range in tm of all sequence variants of the oligo
  (in Celcius degrees).}
  \item{deltaGMean}{Mean delta G of all sequence variants of the oligo
  (in kcal/mol).}
  \item{deltaG}{Range in delta G of all sequence variants of the oligo
  (in kcal/mol).}
  \item{sequence}{All sequence variants of the oligo.}
  \item{sequenceRc}{Reverse complements of all sequence variants.}
  \item{gcContent}{GC-content of all sequence variants.}
  \item{tm}{Tm of all sequence variants (in Celcius degrees).}
  \item{deltaG}{Delta G of all sequence variants (in kcal/mol).}
  \item{method}{Design method used to generate the oligo: "ambiguous",
  "mixedFwd" or "mixedRev".}
  \item{score}{Oligo score, the lower the better.}
  \item{roiStart}{First position of the input \code{RprimerProfile} object
    (roi = region of interest).}
  \item{roiEnd}{Last position of the input \code{RprimerProfile} object.}
}

An error message will return if no oligos are found. If so, a good idea
could be to re-run the design process with relaxed constraints.
}
\description{
\code{designOligos()} designs oligos (primers and probes)
from a consensus profile.
}
\details{
\strong{Valid oligos}

For an oligo to be considered as valid, all sequence variants must fulfill
all the specified design constraints.

Furthermore, oligos with at least one sequence variant containing
more than four consecutive runs
of the same
nucleotide (e.g. "AAAAA") and/or more than three consecutive runs
of the same di-nucleotide (e.g. "TATATATA") will be excluded
from consideration.

\strong{Calculation of tm and delta G}

Melting temperatures
are calculated for perfectly matching
DNA duplexes using the
nearest-neighbor
method (SantaLucia and Hicks, 2004), by using the following equation:

\loadmathjax
\mjsdeqn{Tm = (\Delta H ^o \cdot 1000) / (\Delta S ^o + R \cdot \log [\mathrm{oligo}]) - 273.15}

where \mjseqn{\Delta H ^o} is
the change in enthalpy (in cal/mol) and \mjseqn{\Delta S ^o} is the
change in entropy (in cal/K/mol) when an
oligo and a perfectly matching target sequence goes from random coil to
duplex formation.
\mjseqn{K} is the gas constant (1.9872 cal/mol \emph{K}).

Delta G is calculated at 37 Celcius degrees, for when an oligo and a
perfectly matching target
sequence goes from random coil to duplex state, by using  the following
equation:

\mjsdeqn{ \Delta G ^o _T = ( \Delta H ^o \cdot 1000 - T \cdot \Delta S ^o ) / 1000}{ASCII representation}
For both tm and delta G, the following salt correction method is used
for \mjseqn{ \Delta S^o }, as
described in SantaLucia and Hicks (2004):

\mjsdeqn{ \Delta S^o [\mathrm{Na^+}] = \Delta S^o [\mathrm{1 M NaCl}] + 0.368 \cdot N / 2 \cdot \log [\mathrm{Na^+}] }

where \mjseqn{N} is the total number of phosphates in the duplex, and [Na+] is
the total
concentration of monovalent cations.

Nearest neighbor table values for \mjseqn{\Delta S^o} and \mjseqn{\Delta H^o} are
from SantaLucia and Hicks, 2004, and can be
retrieved calling \code{rprimer:::lookup$nn}.

\strong{Primer design strategies}

Primers can be generated by using one of the two following strategies:

\itemize{
\item{The \strong{ambiguous strategy} (default) generates primers from the
IUPAC consensus sequence alone, which means that ambiguous bases can
occur at any position in the primer.}

\item{The \strong{mixed strategy} generates primers from both the majority
and the IUPAC consensus sequence. These primers consist of a shorter
degenerate part at the 3' end (approx. 1/3 of the primer, targeting a
conserved
region) and a longer consensus part at the 5' end (approx.
2/3 of the primer),
which instead of having ambiguous bases contains the most frequently occuring
nucleotide at each position.
This strategy resembles the widely-adopted Consensus-Degenerate Hybrid
Oligonucleotide Primer (CODEHOP) principle (Rose et al., 1998), and aims to
to allow amplification of highly variable targets using primers with
low degeneracy.
The idea is that the degenerate 3' end part will bind specifically to
the target sequence in the initial PCR cycles, and promote amplification
in spite of eventual mismatches at the 5' consensus part
(since 5' end mismatches are generally less detrimental than
3' end mismatches). In this way, the generated products
will match the 5' ends of all primers perfectly, which allows them
to be efficiently amplified in later PCR cycles.
To provide a sufficiently high tm in spite of mismatches, it is
recommended to design relatively long primers (at least 25 bases) when using
this strategy.}
}

Probes are always designed using the ambiguous strategy.

\strong{Scoring system for oligos}

All valid oligos are scored based on their identity, coverage and
average GC content. The scoring system is presented below.

\strong{Identity and coverage}

\tabular{lr}{
Value range \tab Score \cr
\eqn{(0.99, 1]} \tab 0 \cr
\eqn{(0.95, 0.99]} \tab 1 \cr
\eqn{(0.90, 0.95]} \tab 2 \cr
\eqn{\leq 0.90} \tab 3
}

\strong{Average GC-content}

This score is based on how much
the average GC-content deviates from 0.5 (in absolute value).

\tabular{lr}{
Value range \tab Score \cr
\eqn{[0, 0.05)}
\tab 0 \cr
\eqn{[0.05, 0.1)}
\tab 1 \cr
\eqn{[0.1,  0.2)}
\tab 2 \cr
\eqn{\geq 0.2} \tab 3
}

These scores are summarized. The weight of each individual score is 1, and
thus, the lowest and best
possible score for an oligo is 0, and the worst possible score is 9.
}
\examples{
data("exampleRprimerProfile")
x <- exampleRprimerProfile

## Design primers and probes with default values
designOligos(x)
}
\references{
Rose, TM., Schultz ER., Henikoff JG., Pietrokovski S.,
McCallum CM., and Henikoff S. 1998. Consensus-Degenerate
Hybrid Oligonucleotide Primers for
Amplification of Distantly Related Sequences. Nucleic Acids Research 26 (7):
1628-35.

SantaLucia Jr, J., & Hicks, D. (2004).
The thermodynamics of DNA structural motifs.
Annu. Rev. Biophys. Biomol. Struct., 33, 415-440.
}
