% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Terms.R
\name{olsTerms}
\alias{olsTerms}
\alias{olsTerm}
\alias{olsTerms,character}
\alias{olsTerms,olsOntology}
\alias{termLinks}
\alias{termLinks,olsTerm}
\alias{children}
\alias{parents}
\alias{ancestors}
\alias{descendants}
\alias{termSynonym}
\alias{termSynonym,olsTerm}
\alias{termSynonym,olsTerms}
\alias{isObsolete}
\alias{isObsolete,olsTerm}
\alias{isObsolete,olsTerms}
\alias{isRoot}
\alias{isRoot,olsTerm}
\alias{isRoot,olsTerms}
\alias{termLabel}
\alias{termLabel,olsTerm}
\alias{termLabel,olsTerms}
\alias{termId}
\alias{termId,olsTerm}
\alias{termId,olsTerms}
\alias{termPrefix}
\alias{termPrefix,olsTerm}
\alias{termPrefix,olsTerms}
\alias{termDesc}
\alias{termDesc,olsTerm}
\alias{termDesc,olsTerms}
\alias{termOntology}
\alias{termOntology,olsTerm}
\alias{termOntology,olsTerms}
\alias{termNamespace}
\alias{termNamespace,olsTerm}
\alias{termNamespace,olsTerms}
\alias{olsTerms,character-method}
\alias{olsTerms,olsOntology-method}
\alias{olsTerm,character-method}
\alias{olsTerm,olsOntology-method}
\alias{show,olsTerm-method}
\alias{show,olsTerms-method}
\alias{termSynonym,olsTerm-method}
\alias{termSynonym,olsTerms-method}
\alias{isObsolete,olsTerm-method}
\alias{isObsolete,olsTerms-method}
\alias{isRoot,olsTerm-method}
\alias{isRoot,olsTerms-method}
\alias{termLabel,olsTerm-method}
\alias{termLabel,olsTerms-method}
\alias{termId,olsTerm-method}
\alias{termId,olsTerms-method}
\alias{termLinks,olsTerm-method}
\alias{termPrefix,olsTerm-method}
\alias{termPrefix,olsTerms-method}
\alias{termDesc,olsTerm-method}
\alias{termDesc,olsTerms-method}
\alias{termOntology,olsTerm-method}
\alias{termOntology,olsTerms-method}
\alias{termNamespace,olsTerm-method}
\alias{termNamespace,olsTerms-method}
\alias{length,olsTerms-method}
\alias{unique,olsTerms-method}
\alias{[,olsTerms-method}
\alias{[[,olsTerms-method}
\alias{lapply,olsTerms-method}
\alias{as.olsTerm.data.frame}
\alias{as.olsTerms.data.frame}
\title{Ontology Terms}
\usage{
\S4method{olsTerms}{character}(object, pagesize = 1000, obsolete = NULL)

\S4method{olsTerms}{olsOntology}(object, pagesize = 1000, obsolete = NULL)

\S4method{olsTerm}{character}(object, id)

\S4method{olsTerm}{olsOntology}(object, id)

children(object)

parents(object)

ancestors(object)

descendants(object)

\S4method{show}{olsTerm}(object)

\S4method{show}{olsTerms}(object)

\S4method{termSynonym}{olsTerm}(object)

\S4method{termSynonym}{olsTerms}(object)

\S4method{isObsolete}{olsTerm}(object)

\S4method{isObsolete}{olsTerms}(object)

\S4method{isRoot}{olsTerm}(object)

\S4method{isRoot}{olsTerms}(object)

\S4method{termLabel}{olsTerm}(object)

\S4method{termLabel}{olsTerms}(object)

\S4method{termId}{olsTerm}(object)

\S4method{termId}{olsTerms}(object)

\S4method{termLinks}{olsTerm}(object)

\S4method{termPrefix}{olsTerm}(object)

\S4method{termPrefix}{olsTerms}(object)

\S4method{termDesc}{olsTerm}(object)

\S4method{termDesc}{olsTerms}(object)

\S4method{termOntology}{olsTerm}(object)

\S4method{termOntology}{olsTerms}(object)

\S4method{termNamespace}{olsTerm}(object)

\S4method{termNamespace}{olsTerms}(object)

\S4method{length}{olsTerms}(x)

\S4method{unique}{olsTerms}(x)

\S4method{[}{olsTerms}(x, i, j = "missing", drop = "missing")

\S4method{[[}{olsTerms}(x, i, j = "missing", drop = "missing")

\S4method{lapply}{olsTerms}(X, FUN, ...)

as.olsTerm.data.frame(x)

as.olsTerms.data.frame(x)
}
\arguments{
\item{object}{generally an instance of class `olsTerms` or `olsTerm`. In
some cases, an ontology identifier is applicable.}

\item{pagesize}{`numeric(1)`, converted to an integer, defining
the response page size. Default is 1000.}

\item{obsolete}{`NULL` or `logical(1)` defining whether obsolete
terms (`TRUE`), current terms (`FALSE`) or all (`NULL`,
default) should be returned.}

\item{id}{`character(1)` with the term's identifier.}

\item{x}{a `olsTerms` object.}

\item{i}{index of elecements to subset.}

\item{j}{ignored.}

\item{drop}{ignored.}

\item{X}{`olsTerms` object.}

\item{FUN}{a `function` to be applied to each `olsTerm` element of
`X`.}

\item{...}{additional arguments passed to `FUN`.}
}
\description{
The `olsTerm` class describes an ontology term. A set of terms are
instantiated as a `olsTerms` class.
}
\section{Contructors}{


Objects can be created using the `olsTerm()` and `olsTerms()`
constructers. The latter is used with an object of class
`olsOntology` or a `character` describing a valid ontology prefix
to download and instantiate all terms of an ontology of
interest. The former takes an `olsOntology` object (or an ontology
prefix) and a term identifer to instantiate that specific term.

For any given `olsTerm` object, the `children`, `parents`,
`ancestors` and `descendants` terms can be generated with the
`children()`, `parents()`, `ancestor()` and `descendants()`
function. `olsTerms` instances can be subset with `[` and `[[` and
iterated over with `lapply`.
}

\section{Accessors}{


- `isObsolete(object = "olsTerm")` returns a `TRUE` if the term is
  obsolete, `FALSE` otherwise. Also works on `olsTerms` instances.

- `isRoot(object = "olsTerm")` returns a `TRUE` if the term is a root
  term, `FALSE` otherwise. Also works on `olsTerms` instances.

- `termDesc(object = "olsTerm")` returns a `character` with the
  term's description. Also works on `olsTerms` instances.

- `termId(object = "olsTerm")` returns a `character` with the term's
  identifier. Also works on `olsTerms` instances.

- `termLabel(object = "olsTerm")` returns a `character` with the
  term's label. Also works on `olsTerms` instances.

- `termNamespace(object = "olsTerm")` returns a `character` with the
  term's namespace. Also works on `olsTerms` instances.

- `termOntology(object = "olsTerm")` returns a `character` with the
  term's ontology (where it was retrieved from). Also works on
  `olsTerms` instances.

- `termPrefix(object = "olsTerm")` returns a `character` with the
  term's (ontology) prefix (where it was retrieved from). Also
  works on `olsTerms` instances.

- `termSynonym(object = "olsTerm")` returns a `character` with the
  term's synpnym(s). Also works on `olsTerms` instances.

- `termLinks(object = "olsTerm")` returns a named `character` with
  hyperlink to/from the term.
}

\section{Related terms}{


- `children(object = "olsTerm")` returns a new `olsTerms` instance with
   the `object`'s children or `NULL` if there are no children.

- `parents(object = "olsTerm")` returns a new `olsTerms` instance with
  the `object`'s parents or `NULL` if there are no parents.

- `ancestors(object = "olsTerm")` returns a new `olsTerms` instance with
  the `object`'s ancestors or `NULL` if there are no ancestors.

- `descendants(object = "olsTerm")` returns a new `olsTerms` instance
  with the `object`'s descendants or `NULL` if there are no
  descendants.
}

\section{Coercion}{


- `as(x, "data.fram")` coerces a `olsTerm` or `olsTerms` instance into a
  `data.frame` of length 1 (for the former) or length `length(x)`
  for the latter. The result will contain the following columns:
  id, label, description of the term(s), their ontology, whether
  they are obsolete, have children or are root node, the first
  synonym only, their iri and whether they are defining the
  ontology. Any missing value will be reported as `NA`.
}

\examples{

## Alzheimer's Disease Ontology (ADO)
(adoterms <- olsTerms('ado'))

## Focus on squamous epithelium
(trm <- adoterms[["UBERON:0006914"]])

## Accessors
termLabel(trm)
head(termLabel(adoterms))
termId(trm)
termDesc(trm)
termOntology(trm)
termNamespace(trm)
termSynonym(trm) ## none

## Related terms
children(trm)
descendants(trm) ## includes child

parents(trm)
ancestors(trm) ## includes parent

## A single term from an ontology
olsTerm("ado", "ADO:0000090")
}
\references{
- OLS3 API (the OLS4 API should function identically to the OLS3):
  <http://www.ebi.ac.uk/ols4/ols3help>

- REST API for OLS: <https://www.ebi.ac.uk/ols4/swagger-ui/index.html>
}
\author{
Laurent Gatto
}
