% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot2TX.R
\name{plot2TX}
\alias{plot2TX}
\title{Estimate And Plot Transcript Proportion Difference}
\usage{
plot2TX(dat, genes, step = 0.5, thresholds = c(1, 6), plotcell = 1,
  ...)
}
\arguments{
\item{dat}{A \code{rnaseqcomp} S4 class object.}

\item{genes}{A vector of gene names corresponding to quantified
transcripts. Note that \code{length(genes)} should equal to
\code{nrow(dat@quantData[[1]])}.}

\item{step}{A number specifying the resolution on detrended logsignal
for calculation and plotting the proportion difference.
(default: 0.5)}

\item{thresholds}{A vector of two numbers define cutoffs for
three levels of detreded log signals, where one number summary
will be generated. (default: c(1, 6))}

\item{plotcell}{1 or 2 indicating which cell line
will be plotted. If values other than 1 and 2, both cell
lines will be plotted.  This value won't affect estimation for both
cell lines. (default: 1)}

\item{...}{Parameters for base function \code{plot}.}
}
\value{
\item{plot}{2TX plots of quantification pipelines for
selected cell line by \code{plotcell}.}
\item{list}{A list of two matrices indicating the mean and standard error
of absolute proportion differences. Valuesa are based
on average of  two cell lines.}
}
\description{
For any compared two replicates in each cell line,
the proportion of one transcript for genes that only include two
annotated transcripts can be different even flipped. This function
estimates and plots the proportion difference stratefied by detrended
logsignal. Means of absolute difference will be reported for three
levels of detrened logsignals. Average is used when multiple
two-replicate comparisons included.
}
\examples{
data(simdata)
condInfo <- factor(simdata$samp$condition)
repInfo <- factor(simdata$samp$replicate)
evaluationFeature <- rep(TRUE, nrow(simdata$meta))
calibrationFeature <- simdata$meta$house & simdata$meta$chr == 'chr1'
unitReference <- 1
dat <- signalCalibrate(simdata$quant, condInfo, repInfo, evaluationFeature,
calibrationFeature, unitReference, calibrationFeature2 = calibrationFeature)
plot2TX(dat,genes=simdata$meta$gene)
}
