% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestAssociations.R
\name{TestAssociations}
\alias{TestAssociations}
\title{Test associations between phenotype and RNA editing levels.}
\usage{
TestAssociations(
  rnaEdit_df,
  pheno_df,
  responses_char,
  covariates_char = NULL,
  respType = c("binary", "continuous", "survival"),
  progressBar = "time",
  orderByPval = TRUE
)
}
\arguments{
\item{rnaEdit_df}{A data frame with class \code{rnaEdit_df}, which is a
output from function \code{\link{CreateEditingTable}()} or function
\code{\link{SummarizeAllRegions}()}. This data frame should include RNA
editing level values, with row names as site IDs or region IDs, and column
names as sample IDs.}

\item{pheno_df}{A data frame with phenotype and covariates, which should
include all the samples in \code{rnaEdit_df}. Please make sure the input
\code{pheno_df} has the variable named \code{"sample"} to indicate sample
IDs.}

\item{responses_char}{A character vector of names of response variables in
\code{pheno_df}. When respType is set as \code{"survival"},
\code{responses_char} should have length 2. The first element must be the
name of the variable with following up time, and the second element must 
be status indicator. Status indicator should be coded as 0/1(1=death),
TRUE/FALSE(TRUE=death), or 1/2(death). Please make sure variable names are 
in this order. We have not tested this code on interval-censored data; use 
at your own risk. See \code{\link[survival]{Surv}} for more details.}

\item{covariates_char}{A character vector of names of covariate variables in
\code{pheno_df}.}

\item{respType}{Type of outcome. Defaults to \code{"binary"}.}

\item{progressBar}{Name of the progress bar to use. There are currently five
types of progress bars: \code{"time"}, \code{"none"}, \code{"text"},
\code{"tk"}, and \code{"win"}. Defaults to \code{"time"}. See
\code{\link[plyr]{create_progress_bar}} for more details.}

\item{orderByPval}{Sort co-edited regions by model p-value or not? Defaults
to TRUE.}
}
\value{
A data frame with locations of the genomic regions or sites
  (\code{seqnames, start, end, width}), test statistics
  (\code{estimate, stdErr} or \code{coef, exp_coef, se_coef}), \code{pValue}
  and false discovery rate (\code{fdr}).
}
\description{
A wrapper function to test associations between phenotype and
  RNA editing levels in single-site analysis or summarized RNA editing 
  levels in region-based analysis.
}
\examples{
  data(rnaedit_df)
  
  genes_gr <- TransformToGR(
    genes_char = c("PHACTR4", "CCR5", "METTL7A"),
    type = "symbol",
    genome = "hg19"
  )
  
  exm_regions <- AllCoeditedRegions(
    regions_gr = genes_gr,
    rnaEditMatrix = rnaedit_df,
    output = "GRanges",
    method = "spearman"
  )
  
  sum_regions <- SummarizeAllRegions(
    regions_gr = exm_regions,
    rnaEditMatrix = rnaedit_df,
    selectMethod = MaxSites
  )
  
  exm_pheno <- readRDS(
    system.file(
    "extdata",
    "pheno_df.RDS",
    package = 'rnaEditr',
    mustWork = TRUE
    )
  )
  
  TestAssociations(
    rnaEdit_df = sum_regions,
    pheno_df = exm_pheno,
    responses_char = "sample_type",
    covariates_char = NULL,
    respType = "binary"
  )

}
\seealso{
\code{\link{TransformToGR}}, \code{\link{AllCloseByRegions}}, 
  \code{\link{AllCoeditedRegions}}, \code{\link{CreateEditingTable}},
  \code{\link{SummarizeAllRegions}}, \code{\link{AnnotateResults}}
}
