% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllCloseByRegions.R
\name{AllCloseByRegions}
\alias{AllCloseByRegions}
\title{Extract clusters of RNA editing sites located closely in genomic 
  regions.}
\usage{
AllCloseByRegions(
  regions_gr,
  rnaEditMatrix,
  maxGap = 50,
  minSites = 3,
  progressBar = "time"
)
}
\arguments{
\item{regions_gr}{A GRanges object of input genomic regions.}

\item{rnaEditMatrix}{A matrix (or data frame) of RNA editing level values on
individual sites, with row names as site IDs in the form of
"chrAA:XXXXXXXX", and column names as sample IDs. Please make sure to
follow the format of example dataset (\code{data(rnaedit_df)}).}

\item{maxGap}{An integer, genomic locations within \code{maxGap} from each
other are placed into the same cluster. Defaults to 50.}

\item{minSites}{An integer, minimum number of RNA editing sites within each
resulting cluster. Defaults to 3.}

\item{progressBar}{Name of the progress bar to use. There are currently five
types of progress bars: \code{"time"}, \code{"none"}, \code{"text"},
\code{"tk"}, and \code{"win"}. Defaults to \code{"time"}. See
\code{\link[plyr]{create_progress_bar}} for more details.}
}
\value{
A GRanges object containing genomic regions of RNA editing sites
  located closely within each input pre-defined genomic region.
}
\description{
A wrapper function to extract clusters of RNA editing sites
  that are located closely in genomic regions.
}
\details{
The algorithm of this function is based on the
  \code{\link[bumphunter]{clusterMaker}} function in the \code{bumphunter}
  R package. Each cluster is essentially a group of site locations such that
  two consecutive locations in the cluster are separated by less than
  \code{maxGap}.
}
\examples{
  data(rnaedit_df)
  
  exm_regions <- TransformToGR(
    genes_char = c("PHACTR4", "CCR5", "METTL7A"),
    type = "symbol",
    genome = "hg19"
  )
  
  AllCloseByRegions(
    regions_gr = exm_regions,
    rnaEditMatrix = rnaedit_df,
    maxGap = 50,
    minSites = 3,
    progressBar = "time"
  )  
   
}
\seealso{
\code{\link{TransformToGR}}, \code{\link{AllCoeditedRegions}}, 
  \code{\link{CreateEditingTable}}, \code{\link{SummarizeAllRegions}}, 
  \code{\link{TestAssociations}}, \code{\link{AnnotateResults}}
}
