% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strandPlot.R
\name{strandPlot}
\alias{strandPlot}
\title{Plot the distribution of reads in sense and antisense strand}
\usage{
strandPlot(
  reads,
  CDS,
  col = c("#009E73", "#D55E00"),
  ignore.seqlevelsStyle = FALSE,
  ...
)
}
\arguments{
\item{reads}{Output of \link{getPsiteCoordinates}}

\item{CDS}{Output of \link{prepareCDS}}

\item{col}{Coloar for sense and antisense strand.}

\item{ignore.seqlevelsStyle}{Ignore the sequence name style detection or not.}

\item{...}{Parameter passed to barplot}
}
\value{
A ggplot object.
}
\description{
Plot the distribution of reads in sense and antisense strand to
check the mapping is correct.
}
\examples{
library(Rsamtools)
bamfilename <- system.file("extdata", "RPF.WT.1.bam",
                           package="ribosomeProfilingQC")
yieldSize <- 10000000
bamfile <- BamFile(bamfilename, yieldSize = yieldSize)
pc <- getPsiteCoordinates(bamfile, bestpsite=11)
pc.sub <- pc[pc$qwidth \%in\% c(29, 30)]
library(txdbmaker)
library(BSgenome.Drerio.UCSC.danRer10)
txdb <- makeTxDbFromGFF(system.file("extdata",
          "Danio_rerio.GRCz10.91.chr1.gtf.gz",
          package="ribosomeProfilingQC"),
          organism = "Danio rerio",
          chrominfo = seqinfo(Drerio)["chr1"],
          taxonomyId = 7955)
CDS <- prepareCDS(txdb)
strandPlot(pc.sub, CDS)

}
