% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateRPF.R
\name{simulateRPF}
\alias{simulateRPF}
\title{Simulation function}
\usage{
simulateRPF(
  txdb,
  outPath,
  genome,
  samples = 6,
  group1 = c(1, 2, 3),
  group2 = c(4, 5, 6),
  readsPerSample = 1e+06,
  readsLen = 28,
  psite = 13,
  frame0 = 0.9,
  frame1 = 0.05,
  frame2 = 0.05,
  DEregions = GRanges(),
  size = 1,
  sd = 0.02,
  minDElevel = log2(2),
  includeReadsSeq = FALSE
)
}
\arguments{
\item{txdb}{A TxDb object}

\item{outPath}{Output folder for the bam files}

\item{genome}{A BSgenome object}

\item{samples}{Total samples to simulate.}

\item{group1, group2}{Numeric to index the sample groups.}

\item{readsPerSample}{Total reads number per sample.}

\item{readsLen}{Reads length, default 100bp.}

\item{psite}{P-site position. default 13.}

\item{frame0, frame1, frame2}{Percentage of reads distribution in
frame0, frame1 and frame2}

\item{DEregions}{The regions with differential reads in exon,
utr5 and utr3.}

\item{size}{Dispersion parameter. Must be strictly positive.}

\item{sd}{Standard deviations.}

\item{minDElevel}{Minimal differential level. default: log2(2).}

\item{includeReadsSeq}{logical(1). Include reads sequence or not.}
}
\value{
An invisible list of GAlignments.
}
\description{
Simulate the RPFs reads in CDS, 5'UTR and 3'UTR
}
\examples{
library(GenomicFeatures)
txdb_file <- system.file("extdata", "Biomart_Ensembl_sample.sqlite",
                         package="GenomicFeatures")
txdb <- loadDb(txdb_file)
simulateRPF(txdb, samples=1, readsPerSample = 1e3)
\dontrun{
cds <- prepareCDS(txdb, withUTR = TRUE)
cds <- cds[width(cds)>200]
DEregions <- cds[sample(seq_along(cds), 10)]
simulateRPF(txdb, samples=6, readsPerSample = 1e5, DEregions=DEregions)
}
}
