% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareCDS.R
\name{prepareCDS}
\alias{prepareCDS}
\title{Prepare CDS}
\usage{
prepareCDS(txdb, withUTR = FALSE)
}
\arguments{
\item{txdb}{A TxDb object.}

\item{withUTR}{Including UTR information or not.}
}
\value{
A GRanges object with metadata which include:
tx_id: transcript id;
tx_name: transcript name;
gene_id: gene id;
isFirstExonInCDS: is first exon in CDS or not;
idFirstExonInCDS: the id for the first exon;
isLastExonInCDS: is last exon in CDS or not;
wid.cumsu: cumulative sums of number of bases in CDS;
internalPos: offset position from 1 base;
}
\description{
Prepare CDS library from a TxDb object.
}
\examples{
library(GenomicFeatures)
txdb_file <- system.file("extdata", "Biomart_Ensembl_sample.sqlite",
                         package="GenomicFeatures")
txdb <- loadDb(txdb_file)
CDS <- prepareCDS(txdb)

}
