% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_functions.R
\name{get_metadata}
\alias{get_metadata}
\title{Retrieves the metadata of an experiment}
\usage{
get_metadata(ribo.object, name = NULL, print = TRUE)
}
\arguments{
\item{ribo.object}{object of class 'ribo'}

\item{name}{The name of the experiment}

\item{print}{Logical value indicating whether or not to neatly print the output}
}
\value{
If a valid experiment name is provided, a list of elements providing all of the metadata of the
experiment is returned.

If the name is not provided and the root file has metadata, then a list of elements
providing all of the metadata found in the root file is returnend.
}
\description{
\code{\link{get_metadata}} provides information on all of the user-inputted
metadata of an experiment. If the experiment is not found, then the
attributes of the root .ribo file is returned instead.
}
\examples{
#ribo object use case
#generate the ribo object
file.path <- system.file("extdata", "sample.ribo", package = "ribor")
sample <- Ribo(file.path)

#the ribo file contains an experiment named 'Hela_1'
get_metadata(sample, "Hela_1")

}
\seealso{
\code{\link{Ribo}} to generate the necessary ribo.object parameter
}
