% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11_plotAA.R
\name{plotAA}
\alias{plotAA}
\title{Visualize amino acid differences against a reference (fast zoom & highlighting)}
\usage{
plotAA(
  aln_aa_set,
  ref_name = NULL,
  xlim = NULL,
  center = NULL,
  window = NULL,
  showLegend = FALSE,
  colorMapAA = c(R = "red2", H = "red2", K = "red2", D = "blue2", E = "blue2", S =
    "green3", T = "green3", N = "green3", Q = "green3", A = "gold", V = "gold", I =
    "gold", L = "gold", M = "gold", F = "gold", W = "gold", P = "gold", G = "gold", Y =
    "gold", C = "gold"),
  colorFallback = "grey50",
  highlight_seqs = NULL,
  highlight_bg = grDevices::adjustcolor("#FFE082", alpha.f = 0.5),
  lwd_normal = 1,
  lwd_highlight = 2,
  seg_half_height = 0.35,
  y_cex = 0.8,
  line_col = "grey20",
  show_only_highlighted = FALSE
)
}
\arguments{
\item{aln_aa_set}{A `Biostrings::AAStringSet` of aligned amino acid
sequences (all sequences must be the same width).}

\item{ref_name}{Character scalar; the sequence name in `aln_aa_set` to use as
reference. If `NULL`, the last sequence is used.}

\item{xlim}{Optional integer length-2 vector giving the protein window to
display, e.g. `c(5, 20)`. If omitted, the entire span is shown.}

\item{center, window}{Optional integers; alternatively specify a zoom by
center position and window width (e.g., `center = 150, window = 50`).
Ignored if `xlim` is provided.}

\item{showLegend}{Logical; if `TRUE`, draws a compact legend for the five
amino acid classes. Default: `FALSE`.}

\item{colorMapAA}{Named character vector mapping amino acids to colors. The
default assigns one color per residue class (see Details).}

\item{colorFallback}{Color used for any symbol not present in `colorMapAA`
(e.g., `X`, `-`). Default: `"grey50"`.}

\item{highlight_seqs}{Optional character vector of sequence IDs (row names)
to visually emphasize in the plot (adds a translucent row band and thicker
mismatch strokes). Sequences are still shown unless
`show_only_highlighted = TRUE`.}

\item{highlight_bg}{Fill color for emphasized rows (semi-transparent
recommended). Default: translucent amber.}

\item{lwd_normal, lwd_highlight}{Line widths for mismatch segments in normal
vs highlighted rows. Defaults: `1` and `2`.}

\item{seg_half_height}{Vertical half-height of each mismatch segment (in row
units). Default: `0.35`.}

\item{y_cex}{Expansion factor for y-axis (sequence labels). Default: `0.8`.}

\item{line_col}{Baseline axis/line color. Default: `"grey20"`.}

\item{show_only_highlighted}{Logical; if `TRUE`, display only the rows whose
IDs are listed in `highlight_seqs`. Default: `FALSE`.}
}
\value{
Invisibly returns the precomputed cache (class `"SNPeekCache"`)
  used for plotting. The primary output is a base R plot drawn to the
  active device.
}
\description{
`plotAA()` plots per–position amino acid differences between an aligned
set of protein sequences and a chosen reference. It reuses the same cache and
fast redraw machinery as [SNPeek()], with an amino acid color map grouping
residues into biochemical classes:

* Positively charged (Arg, His, Lys) – red
* Negatively charged (Asp, Glu) – blue
* Polar uncharged (Ser, Thr, Asn, Gln) – green
* Nonpolar / aromatic / special (all others) – gold
* Other/unknown (X, gaps) – grey

By default (no `xlim`/`center`+`window`), the function plots the full
alignment span and all sequences. Users can zoom to regions of interest and
optionally emphasize specific sequence IDs without hiding the others.
}
\details{
Internally, `plotAA()` calls [compute_cache()] with an amino acid–specific
color map, then passes the result to [plot_window()] for fast drawing. The
returned cache can be reused for repeated zooms without recomputation.

When `showLegend = TRUE`, the legend shows only five biochemical classes
(positively charged, negatively charged, polar uncharged, nonpolar/aromatic,
and other).
}
\examples{
# Create a protein alignment 
aa <- Biostrings::AAStringSet(c(
  Ref = "MTEYKLVVVGYKL",
  S1  = "MTEYKLVILVVVG",
  S2  = "MTEYKLVVV-LVV"
))

# 1) Full span, default reference (last sequence)
plotAA(aa)

# 2) Choose a reference and zoom
plotAA(aa, ref_name = "Ref", xlim = c(3, 8))

# 3) Highlight a sequence of interest
plotAA(aa, ref_name = "Ref", xlim = c(3, 8),
       highlight_seqs = "S1", showLegend = TRUE)

}
\seealso{
[SNPeek()] for the nucleotide version; [compute_cache()],
  [plot_window()] for internals.

Other visualization: 
\code{\link{SNPeek}()},
\code{\link{plotDistances}()},
\code{\link{plotFrequency}()},
\code{\link{plotTree}()}
}
\concept{visualization}
