% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_SNPeek.R
\name{SNPeek}
\alias{SNPeek}
\title{Visualize SNP differences against a reference (fast zoom & highlighting)}
\usage{
SNPeek(
  aln_set,
  ref_name = NULL,
  xlim = NULL,
  center = NULL,
  window = NULL,
  showLegend = FALSE,
  colorMapNT = c(A = "green3", T = "red2", C = "blue2", G = "gold"),
  colorFallback = "grey50",
  highlight_seqs = NULL,
  highlight_bg = grDevices::adjustcolor("#FFE082", alpha.f = 0.5),
  lwd_normal = 1,
  lwd_highlight = 2,
  seg_half_height = 0.35,
  y_cex = 0.8,
  line_col = "grey20",
  show_only_highlighted = FALSE
)
}
\arguments{
\item{aln_set}{A [`Biostrings::DNAStringSet`] of aligned sequences
(all sequences must have identical width).}

\item{ref_name}{Character; the sequence name in `aln_set` to use as
reference. If `NULL`, the last sequence is used.}

\item{xlim}{Optional integer length-2 vector giving the genomic window,
e.g. `c(100, 200)`. If omitted, the entire span is shown.}

\item{center, window}{Optionally specify a zoom by center position and
window width (e.g., `center = 5012, window = 600`). Ignored if `xlim`
is provided.}

\item{showLegend}{Logical; if `TRUE`, draws a legend for the nucleotide
color map. Default: `FALSE`.}

\item{colorMapNT}{Named character vector mapping nucleotides to colors.
Default: `c(A = "green3", T = "red2", C = "blue2", G = "gold")`.}

\item{colorFallback}{Color for any non-ATCG symbol (e.g., `N`, `-`).
Default: `"grey50"`.}

\item{highlight_seqs}{Optional character vector of sequence IDs (row names)
to emphasize (adds a translucent row band and thicker mismatch strokes).
All sequences are still shown unless `show_only_highlighted = TRUE`.}

\item{highlight_bg}{Fill color for emphasized rows (use
`grDevices::adjustcolor()` for transparency). Default:
`adjustcolor("#FFE082", alpha.f = 0.5)`.}

\item{lwd_normal, lwd_highlight}{Line widths for mismatch segments in normal
vs highlighted rows. Defaults: `1` and `2`.}

\item{seg_half_height}{Vertical half-height of each mismatch segment (row
units). Default: `0.35`.}

\item{y_cex}{Expansion factor for y-axis (sequence labels). Default: `0.8`.}

\item{line_col}{Baseline axis/line color. Default: `"grey20"`.}

\item{show_only_highlighted}{Logical; if `TRUE`, display only rows whose
IDs are in `highlight_seqs`. Default: `FALSE`.}
}
\value{
Invisibly returns the precomputed cache (class `"SNPeekCache"`)
  used for plotting. The primary output is a base R plot.
}
\description{
`SNPeek()` renders per–position nucleotide differences between an aligned
set of DNA sequences and a chosen reference using a cached pre-computation
for fast redraws. With no `xlim`/`center`+`window`, it plots the full
genome span and **all** sequences. Users can zoom regions and optionally
emphasize specific sequence IDs with(out) hiding the others.
}
\details{
Internally, `SNPeek()` builds a reusable cache of mismatch
positions and color indices versus the reference, then subsets to 
the requested window before plotting for speed.
The cache is returned invisibly so you can reuse it 
for interactive workflows without recomputation.
}
\examples{
fasta_file <- system.file("extdata", "input_aln.fasta", package = "rhinotypeR")
aln <- Biostrings::readDNAStringSet(fasta_file)

# Full span
SNPeek(aln)

# Zoom + highlight
SNPeek(aln, xlim = c(100, 200),
       highlight_seqs = c("MT177780.1", "MT177798.1"),
       showLegend = TRUE)

}
\seealso{
`plotAA()` for the amino-acid analogue.

Other visualization: 
\code{\link{plotAA}()},
\code{\link{plotDistances}()},
\code{\link{plotFrequency}()},
\code{\link{plotTree}()}
}
\concept{visualization}
