% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_visualizationHelpers.R
\name{SNPeek-internal}
\alias{SNPeek-internal}
\alias{compareAndColorSequences}
\alias{compute_cache}
\alias{SNPeekCache}
\alias{subset_cache}
\alias{plot_window}
\title{Internal helpers for SNPeek/plotAA}
\usage{
compareAndColorSequences(sequences, colorMap, colorFallback = "gray")

compute_cache(aln_set, ref_name = NULL, colorMap, colorFallback = "grey")

subset_cache(cache, keep_idx)

plot_window(
  cache,
  xlim = NULL,
  center = NULL,
  window = NULL,
  showLegend = FALSE,
  highlight_seqs = NULL,
  highlight_bg = "#FFE08280",
  lwd_normal = 1,
  lwd_highlight = 2,
  seg_half_height = 0.35,
  y_cex = 0.8,
  line_col = "grey20",
  show_only_highlighted = FALSE
)
}
\arguments{
\item{sequences}{Character vector (named preferred) of equal-length, aligned
sequences. The first element is treated as the reference.}

\item{colorMap}{Named vector mapping symbols (e.g., nucleotides) to colors.
Used to render mismatches. For symbols not present, \code{colorFallback} is used.}

\item{colorFallback}{Color used when a symbol is not in \code{colorMap}.}

\item{aln_set}{\code{Biostrings::DNAStringSet} or \code{Biostrings::AAStringSet}
containing an aligned, equal-width alignment.}

\item{ref_name}{Optional character; the sequence name to use as the reference.
Defaults to the last sequence in \code{aln_set}.}

\item{cache}{An object from \code{\link[=compute_cache]{compute_cache}}
(class \code{"SNPeekCache"}).}

\item{keep_idx}{Integer vector of 1-based row indices to retain. Values
outside the valid range are ignored.}

\item{xlim}{Integer length-2 vector giving the genomic range to display.
If omitted, you can provide \code{center} and \code{window} for quick zoom.}

\item{center}{Integer center position for quick zoom (used with \code{window}).}

\item{window}{Integer window width for quick zoom (used with \code{center}).}

\item{showLegend}{Logical; draw a small legend for the color map.}

\item{highlight_seqs}{Character vector of sequence names to visually
highlight (background shading and thicker ticks).}

\item{highlight_bg}{Background color for highlighted rows (can include alpha).}

\item{lwd_normal}{Numeric line width for non-highlighted ticks.}

\item{lwd_highlight}{Numeric line width for highlighted ticks.}

\item{seg_half_height}{Half-height of mismatch ticks (in plot y-units).}

\item{y_cex}{Character expansion for y-axis (sequence name) labels.}

\item{line_col}{Color for axes/frame elements.}

\item{show_only_highlighted}{Logical; if \code{TRUE} and \code{highlight_seqs}
are provided, only those rows are drawn.}
}
\value{
A list (length = \code{length(sequences) - 1}) of data frames with
  columns \code{position} (integer), \code{subsType} (character), and
  \code{color} (character), one per non-reference sequence.

An object of class \code{"SNPeekCache"} (a list) with elements:
  \itemize{
    \item \code{genome_len} (integer)
    \item \code{seq_names} (character)
    \item \code{ref_label} (character)
    \item \code{ref_row} (integer; row index of the reference)
    \item \code{diffs_list} (list of per-sequence mismatch positions & color indices)
    \item \code{col_levels} (character; palette including fallback as last element)
    \item \code{colorMap}, \code{colorFallback}
  }

A pruned \code{"SNPeekCache"} object containing only the selected
  sequences. The original metadata (e.g., \code{ref_row}) is preserved and
  is not used directly by the drawing code.

Invisibly returns a list with \code{xlim}, \code{n_sequences}, and
  \code{highlighted} sequence names.
}
\description{
Utilities used by SNPeek/plotAA for caching and fast drawing.
These functions are documented for transparency but are **not** part of the
public API.

Given an aligned set of sequences (first element treated as the reference),
find positions where each non-reference sequence differs and assign colors
based on a user-supplied map.

Precomputes mismatch positions vs. a chosen reference and compact color
indices for quick re-drawing of windows without rescanning the alignment.

Keeps only the specified row indices from an \code{SNPeekCache}. Useful for
drawing views that focus on a subset (e.g., highlighted sequences).

Low-level renderer used by higher-level plotting helpers. Plots mismatch
ticks relative to a cached reference over a specified genomic span, with
optional highlighting and a legend.
}
\examples{
\dontrun{
seqs <- c(Ref="ATGC", S1="ATGT", S2="ATAC")
cmap <- c(A="green", T="red", C="blue", G="gold")
compareAndColorSequences(seqs, cmap)
}

\dontrun{
f <- system.file("extdata","test.fasta", package="rhinotypeR")
aln <- Biostrings::readDNAStringSet(f)
cache <- compute_cache(aln, ref_name = tail(names(aln), 1))
}

\dontrun{
cache2 <- subset_cache(cache, c(1, 3, 5))
}

\dontrun{
cache <- compute_cache(aln)
plot_window(cache, center = 200, window = 150,
            highlight_seqs = cache$seq_names[1:3], showLegend = TRUE)
}

}
\seealso{
\code{\link[=compute_cache]{compute_cache}},
  \code{\link[=plot_window]{plot_window}}

\code{\link[=compute_cache]{compute_cache}}
}
\keyword{internal}
