% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{trans}
\alias{trans}
\title{Function to apply a transformation to the exposures of an ExposomeSet}
\usage{
trans(object, fun, select, by.exposure = FALSE, ...)
}
\arguments{
\item{object}{\code{ExposomeSet} which exposures will be transformed.}

\item{fun}{Function to be applied on the exposures.}

\item{select}{If not set, receive the name of all exposures. It can takes a
character vector to select specific exposures.}

\item{by.exposure}{(default \code{FALSE}) If \code{TRUE} applies \code{fun}
to each exposure (given as a vector ). If \code{FALSE} the matrix of
exposures is fiven to \code{fun}.}

\item{...}{Argument given to \code{fun}.}
}
\value{
A new \code{ExposomeSet} with selected exposures transformed with
\code{fun}.
}
\description{
The exposures in an \link{ExposomeSet} can be transformed using this
function. \code{transform} apples a function \code{fun} to the selected
exposures.
}
\examples{
data("exposome")
exp.t <- trans(expo, fun = log, select = "ldde_lip")
}
\seealso{
\link{highAndLow} to transform the continuous exposures to levelled
factors, \link{standardize} to standardize by normal or robust methods the
exposures
}
