% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readExposome.R
\name{readExposome}
\alias{readExposome}
\title{Creation of an ExposomeSet from files}
\usage{
readExposome(
  exposures,
  description,
  phenotype,
  sep = ",",
  na.strings = c("NA", "-", "?", " ", ""),
  exposures.samCol = "sample",
  description.expCol = "exposure",
  description.famCol = "family",
  phenotype.samCol = "sample",
  exposures.asFactor = 5,
  warnings = TRUE
)
}
\arguments{
\item{exposures}{String with the path to the file with the matrix of
exposures.}

\item{description}{String with the path to the file with the description of
the exposures (relation between exposures and exposure-family).}

\item{phenotype}{String with the path to the file with the phenotypes of
interest.}

\item{sep}{(default \code{","}) Separator used by \code{\link{read.table}} to
load the files "exposures", "description" and "phenotype".}

\item{na.strings}{(default \code{c("NA", "-", "?", " ", "")}) Character
defining the \code{NA} values in expsome's files.}

\item{exposures.samCol}{(default \code{"sample"}) Index where the samples'
name are found in file "exposures". It can be both charatcer or numeric.}

\item{description.expCol}{(default \code{"exposure"}) Index where the
exposures' name are found in file "description". It can be both numeric
or character.}

\item{description.famCol}{(default \code{"family"}) Index where the family's
name (per exposures) if found in file "description". It can be both numeric
or character.}

\item{phenotype.samCol}{(default \code{"sample"}) Index where the sample's
name are found in file "phenotype". It can be both numeric or character.}

\item{exposures.asFactor}{(default \code{5}) The exposures with more
than this number of unique items will be considered as "continuous" while
the exposures with less or equal number of items will be considered as
"factor".}

\item{warnings}{(default \code{TRUE}) If \code{TRUE} shows useful
information/warnings from the process of loading the exposome.}
}
\value{
An object of class \link{ExposomeSet}.
}
\description{
Given the files that defines the exposome (measures of exposome, exposome
description and individuals phentype) it loads them and creates an
object of type \link{ExposomeSet}.
}
\details{
The rows of the exposure's file, that corresponds to samples' names, must
be the same than the phenotype's file. In the same way, the columns in
exposure's file must be the same found as rows in description file.
}
\note{
\link{ExposomeSet}'s \code{fData} will contain some inner columns
called \code{.std}, \code{.trn}, \code{.fct} and \code{.type} in order to
trace the transformations an exposure suffers and to know, at eny moment, if
an exposure is categorical or continuous. The "description" file can
contains a column called \code{type} with values \code{"factor"} and
\code{"numeric"} to speficy how an exposure needs to be understood. If
given, this column will be renamed to \code{.type}. If not given, it will
be created using \code{exposures.asFactor} value.
}
\examples{
## Locate the data-files
path <- file.path(path.package("rexposome"), "extdata")
description <- file.path(path, "description.csv")
phenotype <- file.path(path, "phenotypes.csv")
exposures <- file.path(path, "exposures.csv")

## Create ExposomeSet from files
exp <- readExposome(
  exposures = exposures,
  description = description,
  phenotype = phenotype,
  exposures.samCol = 1,
  description.expCol = 2,
  description.famCol = 1,
  phenotype.samCol = 1
)
}
\seealso{
\link{ExposomeSet} for class description,
\link{loadExposome} for constructor from loaded
\code{data.frame}s
}
