% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R
\name{plot3PCA}
\alias{plot3PCA}
\title{Ploting PCA in a 3D space}
\usage{
plot3PCA(
  object,
  cmpX,
  cmpY,
  cmpZ,
  phenotype,
  main,
  angle = 35,
  pch = 16,
  legend = TRUE,
  plines = TRUE
)
}
\arguments{
\item{object}{An onbject of class \link{ExposomePCA}}

\item{cmpX}{Component to be placed at X axis}

\item{cmpY}{Component to be placed at Y axis}

\item{cmpZ}{Component to be placed at Z axis}

\item{phenotype}{Used to color samples by phentoype}

\item{main}{Title for the plot}

\item{angle}{(default \code{35}) angle between x and y axis.}

\item{pch}{(default \code{16}) plotting "character", i.e. symbol to use.}

\item{legend}{(default \code{TRUE}) If \code{TRUE} shows the legend.}

\item{plines}{(default \code{TRUE}) If \code{TRUE} it draws the lines from
each dot to the base plane.}
}
\value{
A \code{list} with different graphics option from \code{scatterplot3d}.
}
\description{
Methdo to draw a plot for samples using three PC contained in an
\link{ExposomePCA}
}
\seealso{
\link{pca} to compite PCA on an \link{ExposomeSet}, \link{plotPCA}
to plot the PCA, \link{ExposomePCA} as main class
data("exposome")
epca <- pca(expo[3:7, 1:100])
plot3PCA(epca, cmpX = 1, cmpY = 2, cmpZ = 3, phenotype = "sex")
}
