% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadExposome_plain.R
\name{loadExposome_plain}
\alias{loadExposome_plain}
\title{Creation of an ExposomeSet from single \code{data.frame}}
\usage{
loadExposome_plain(
  data,
  data_id,
  sep = ",",
  pheno_cols,
  na.strings = c("NA", "-", "?", " ", ""),
  families = NULL,
  exposures.asFactor = 5,
  warnings = TRUE
)
}
\arguments{
\item{data}{\code{data.frame} With the exposures and phenotypes (in no particular order!) or 
\code{string} with the path to a file (.csv, .tsv, .txt) with the table of exposures and phenotypes}

\item{data_id}{\code{character} Name of the column on the selected table that contains the ID}

\item{sep}{\code{character} (default \code{","}) Separator used by \code{\link{read.table}} to
load the files "exposures", "description" and "phenotype". Only applies when providing a path on the 
data argument}

\item{pheno_cols}{\code{character} Character vector of the phenotype columns (all the other columns 
are considered exposures)}

\item{na.strings}{\code{character} (default \code{c("NA", "-", "?", " ", "")}) Character
defining the \code{NA} values in expsome's files.}

\item{families}{\code{list} (default \code{NULL}) List to specify the families of the exposures,
construct it as: \code{list(Family1 = c("exposure_1_1", "exposure_1_2", "exposure_1_n"), Family2 = 
c("exposure_2_1", "exposure_2_2", "exposure_2_n"), FamilyM = c("exposure_M_1", "exposure_M_2", "exposure_M_n"))}. 
All the exposures on the data table have to be on this provided list with their respective families. 
The family classification is optional, input \code{NULL} to bypass the family classifier}

\item{exposures.asFactor}{\code{numeric} (default \code{5}) The exposures with more
than this number of unique items will be considered as "continuous" while
the exposures with less or equal number of items will be considered as
"factor".}

\item{warnings}{(default \code{TRUE}) If \code{TRUE} shows useful
information/warnings from the process of loading the exposome.}
}
\value{
An object of class \link{ExposomeSet}.
}
\description{
Creation of an ExposomeSet from single \code{data.frame}
}
\examples{
path <- file.path(path.package("rexposome"), "extdata")
phenotype <- file.path(path, "phenotypes.csv")
exposures <- file.path(path, "exposures.csv")
ee <- read.csv(exposures, header=TRUE)
pp <- read.csv(phenotype, header=TRUE)
# Create fake dataset with exposures and phenotypes combined
data <- cbind(ee, pp)

loadExposome_plain <- function(data, data_id = "idnum",
pheno_cols = c("rhinitis", "wheezing", "sex", "age", "cbmi", "blood_pre", "whistling_chest","flu"))

}
