% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrofit-package.R, R/retrofit.R
\docType{package}
\name{retrofit}
\alias{retrofit}
\title{RETROFIT}
\usage{
retrofit(
  x,
  sc_ref = NULL,
  marker_ref = NULL,
  L = 16,
  K = 8,
  iterations = 4000,
  init_param = NULL,
  lambda = 0.01,
  kappa = 0.5,
  verbose = FALSE
)
}
\arguments{
\item{x}{A matrix or array with dimension (GeneExpressions, Spots). This is the main spatial transciptomics data.}

\item{sc_ref}{A matrix or array with two dimensions (GeneExpressions, Cell types).}

\item{marker_ref}{A list with (keys, values) = (cell types, an array of genes).}

\item{L}{integer (default:16)    The number of components to be decomposed}

\item{K}{integer: The number of cell types to be selected}

\item{iterations}{integer (default:4000)  The number of maximum iterations to be executed}

\item{init_param}{list                    Vatirational initial parameters}

\item{lambda}{double  (default:0.01)  Background expression profile control}

\item{kappa}{double  (default:0.5)   Learning rate factor}

\item{verbose}{boolean (default:FALSE)}
}
\value{
A list of decomposed vectors that contains
\itemize{
\item decompose: \itemize{
\item w:  Decomposed 2d array with GeneExpressions, Components
\item h:  Decomposed 2d array with Components, Spots
\item th: 1d array with Components
}
\item annotateWithCorrelations: \itemize{
\item w:  Filtered 2d array with GeneExpressions, Cell types
\item h:  Filtered2d array with Cell types, Spots
}
\item annotateWithMarkers: \itemize{
\item w:  Filtered 2d array with GeneExpressions, Cell types
\item h:  Filtered2d array with Cell types, Spots
}
}
}
\description{
The main algorithm
}
\examples{
data("testSimulationData")
iterations  = 10
L           = 16
K           = 8
x           = testSimulationData$extra5_x
sc_ref      = testSimulationData$sc_ref

res         = retrofit::retrofit(x, sc_ref=sc_ref, L=L, K=K, iterations=iterations)
W           = res$decompose$w
W_annotated = res$annotateWithCorrelations$w
ranked_cells= res$annotateWithCorrelations$ranked_cells
}
\seealso{
papers reference
}
