% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decompose.R
\name{decompose}
\alias{decompose}
\title{RETROFIT decomposition algorithm}
\usage{
decompose(
  x,
  L = 16,
  iterations = 4000,
  init_param = NULL,
  lambda = 0.01,
  kappa = 0.5,
  verbose = FALSE
)
}
\arguments{
\item{x}{matrix or array with dimension (GeneExpressions, Spots). This is the main spatial transciptomics data.}

\item{L}{integer (default:16)    The number of components to be decomposed}

\item{iterations}{integer (default:4000)  The number of maximum iterations to be executed}

\item{init_param}{list                    Vatirational initial parameters}

\item{lambda}{double  (default:0.01)  Background expression profile control}

\item{kappa}{double  (default:0.5)   Learning rate factor}

\item{verbose}{boolean (default:FALSE)}
}
\value{
A list of decomposed vectors that contains
\itemize{
\item w:             2d array with GeneExpressions, Components
\item h:             2d array with Components, Spots
\item th:            an array with Components
\item durations:     (verbose) durations vector (unit: second)
\item relative_error:(verbose) errors with pre-defined norm vector
}
}
\description{
Receiving the input with 2d spatial transcriptomics matrix,
the function returns factorized {W, H, Theta}.
This function fulfills Structured Stochastic Variational Inference Algorithm for RETROFIT.
Since exact Bayesian inference is infeasible and considering the large number of spots and genes,
variational inference was adopted to approximately estimate the parameters in performant manner.
}
\details{
init_param specification
\itemize{
\item alpha_w_0   double  (default:0.05)
\item beta_w_0    double  (default:0.0001)
\item alpha_h_0   double  (default:0.2)
\item beta_h_0    double  (default:0.2)
\item alpha_th_0  double  (default:1.25)
\item beta_th_0   double  (default:10)
\item alpha_th_k  array   (default:array with dim c(K))
\item beta_th_k   array   (default:array with dim c(K)),
\item alpha_w_gk  array   (default:array with dim c(G,K)),
\item beta_w_gk   array   (default:array with dim c(G,K)),
\item alpha_h_ks  array   (default:array with dim c(K,S)),
\item beta_h_ks   array   (default:array with dim c(K,S))
}
}
\examples{
data("testSimulationData")
x   = testSimulationData$extra5_x
res = retrofit::decompose(x, L=16, iterations=10, verbose=TRUE)
W   = res$w
H   = res$h
TH  = res$th
}
\seealso{
papers reference
}
