% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproduce_ranges.R
\name{reproduce_ranges}
\alias{reproduce_ranges}
\title{Reproduce the gene or exons used in the RangedSummarizedExperiment objects}
\usage{
reproduce_ranges(level = "gene", db = "Gencode.v25")
}
\arguments{
\item{level}{Either \code{genes} or \code{exon}. It specifies whether to
return Gene or exon level information as a
\link[GenomicRanges:GRanges-class]{GRanges-class} or
\link[GenomicRanges:GRangesList-class]{GRangesList-class} object respectively. The gene level
information contains the width of the disjoint exons for that given gene
which can be used to normalize the counts provided by recount.
Can also be \code{both} in which case a 2 element list with the exon and the
gene output is returned.}

\item{db}{Either \code{Gencode.v25} (default) or
\code{EnsDb.Hsapiens.v79}. The default option reproduces the annotation
used when creating recount. EnsDb.Hsapiens.v79 can be used
for an alternative annotation as showcased in the recount vignette.}
}
\value{
Either a \link[GenomicRanges:GRanges-class]{GRanges-class} object like
\link{recount_genes} or a \link[GenomicRanges:GRangesList-class]{GRangesList-class} object
like \link{recount_exons}.
}
\description{
This function reproduces the gene or exon level information used for creating
the \link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment-class}
objects provided by recount. The annotation is based on
Gencode v25 with the gene-level
information extracted with \code{genes()} (see
\link[GenomicFeatures:transcripts]{transcripts} with default arguments.
}
\details{
For Gencode.v25, we use the comprehensive gene annotation (regions:
\code{CHR}) from \url{https://www.gencodegenes.org/releases/25.html}
(GRCh38.p7).

Note that gene symbols have changed over time. This answer in the
Bioconductor support forum details how to obtain the latest gene symbol
mappings: \url{https://support.bioconductor.org/p/126148/#126173}.
}
\examples{
\dontrun{
## Reproduce gene level information
genes <- reproduce_ranges()

## Compare against recount_genes
length(genes)
length(recount_genes)
}

}
\seealso{
\link{recount_genes}, \link{recount_exons},
\url{https://github.com/nellore},
\url{https://jhubiostatistics.shinyapps.io/recount/}
}
\author{
Leonardo Collado-Torres
}
