% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_predictions.R
\name{add_predictions}
\alias{add_predictions}
\title{Add predicted phenotypes to a recount rse object}
\usage{
add_predictions(rse, is_tcga = FALSE, version = "latest", verbose = TRUE)
}
\arguments{
\item{rse}{A \link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment-class}
object as downloaded with \link{download_study}. If this argument is
not specified, the function will return the full predictions table.}

\item{is_tcga}{Set to \code{TRUE} only when \code{rse} is from TCGA.
Otherwise set to \code{FALSE} (default).}

\item{version}{The version number for the predicted phenotypes data. It has
to match one of the available numbers at
\url{https://github.com/leekgroup/recount-website/blob/master/predictions/}.
Feel free to check if there is a newer version than the default. The version
used is printed as part of the file name.}

\item{verbose}{If \code{TRUE} it will print a message of where the
predictions file is being downloaded to.}
}
\value{
A \link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment-class}
object with the prediction columns appended to the \code{colData()} slot.
The predicted phenotypes are:
\describe{
\item{sex }{ male or female,}
\item{samplesource }{ cell_line or tissue,}
\item{tissue }{ tissue predicted based off of 30 tissues in GTEx,}
\item{sequencingstrategy }{ single or paired end sequencing.}
}
For each of the predicted phenotypes there are several columns as described
next:
\describe{
\item{reported_phenotype }{ \code{NA} when not available,}
\item{predicted_phenotype }{ \code{NA} when we did not predict, "Unassigned"
when prediction was ambiguous,}
\item{accuracy_phenotype }{ accuracy is assigned per dataset based on
comparison to samples for which we had reported phenotype information so
there are three distinct values per predictor (GTEx, TCGA, SRA) across all
studies.}
}
}
\description{
Shannon Ellis et al (2017) predicted phenotypes based on expression data for
the samples in the recount2 project. Using this function you can add the
predictions to a
\link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment-class} object
to the \code{colData()} slot.
}
\details{
If you use these predicted phenotypes please cite the Ellis et al
bioRxiv pre-print available at
https://www.biorxiv.org/content/early/2017/06/03/145656. See citation
details with citation('recount').
}
\examples{

## Add the predictions to an example rse_gene object
rse_gene <- add_predictions(rse_gene_SRP009615)

## Explore the predictions
colData(rse_gene)

## Download all the latest predictions
PredictedPhenotypes <- add_predictions()
}
\references{
Ellis et al, bioRxiv, 2017.
https://www.biorxiv.org/content/early/2017/06/03/145656
}
\author{
Leonardo Collado-Torres
}
