% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_getC1prop.R
\name{getC1prop}
\alias{getC1prop}
\title{Find the dependence pat C1 of the approximate covariance matrix, and extract the ratio of the first eigenvalue to the sum of all positive eigenvalues}
\usage{
getC1prop(statsPerm, numEig = 1, ...)
}
\arguments{
\item{statsPerm}{Matrix of permuted test statistics}

\item{numEig}{An integer, number of first eigenvalues}

\item{...}{passed onto binStats}
}
\value{
A proportion indicating the ratio of the first eigenvalues to the sum of all eigenvalues
}
\description{
Find the dependence pat C1 of the approximate covariance matrix, and extract the ratio of the first eigenvalue to the sum of all positive eigenvalues
}
\examples{
p = 200; n = 50; B = 5e1
x = rep(c(0,1), each = n/2)
mat = cbind(
matrix(rnorm(n*p/10, mean = 5+x),n,p/10), #DA
matrix(rnorm(n*p*9/10, mean = 5),n,p*9/10) #Non DA
)
mat = mat = mat + rnorm(n, sd = 0.3) #Introduce some dependence
fdrRes = reconsi(mat, x, B = B)
getC1prop(fdrRes$statsPerm)
}
