% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectCorrelatedRows.R
\name{selectCorrelatedRows}
\alias{selectCorrelatedRows}
\title{Select features that are correlated with a given feature (or one or more features
from a set of features).}
\usage{
selectCorrelatedRows(Y, X, corThreshold = 0.1, useAbsCor = TRUE)
}
\arguments{
\item{Y}{a vector or matrix; rows from X will be correlated with Y if Y is a vector
or with rows of Y, if Y is a matrix.}

\item{X}{a matrix of values that will be compared with Y (vector) or rows of Y (matrix)}

\item{corThreshold}{the minimum correlation threshold for the row to be returned}

\item{useAbsCor}{a logical value indicating whether absolute correlations should be used
(default=TRUE).}
}
\value{
a matrix of rows of X correlated with Y (if Y is a vector) or correlated with
at least one row of Y if Y is a matrix or data frame.
}
\description{
Select features that are correlated with a given feature (or one or more features
from a set of features).
}
\examples{
vec <- runif(10)
mat <- matrix(runif(100), 10, 10)
selectCorrelatedRows(vec, mat)

}
\concept{rcellminer}
