% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawDiag.R
\name{plotTicBasepeak}
\alias{plotTicBasepeak}
\alias{PlotTicBasepeak}
\title{Total Ion Count and Base Peak Plot}
\usage{
plotTicBasepeak(x, method = "trellis")
}
\arguments{
\item{x}{a \code{data.frame} object adhering to the specified criteria for
the \code{is.rawDiag} function.}

\item{method}{specifying the plot method 'trellis' | 'violin' | 'overlay'.
The default is 'trellis'.}
}
\value{
a ggplot2 object for graphing the TIC and the Base Peak chromatogram.
}
\description{
displays the Total Ion Count (TIC) and the Base Peak Chromatogram
of a mass spectrometry measurement.
Multiple files are handled by faceting based on rawfile name.
}
\examples{
rawrr::sampleFilePath() |> rawDiag::readRaw() |> rawDiag::plotTicBasepeak()
}
\author{
Christian Trachsel (2017), Christian Panse (20231130) refactored
}
