% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randRot.R
\docType{class}
\name{initRandrot-class}
\alias{initRandrot-class}
\alias{initRandrotW-class}
\title{Initialised random rotation class}
\description{
List-based S4 class containing all information necessary to generate randomly
rotated data with the \code{\link[randRotation:randrot]{randrot}} method.
\code{initRandrot} and \code{initRandrotW} objects are created with the
\code{\link[randRotation:initRandrot]{initRandrot}} method.

\code{initRandrotW} is organised as its base class \code{initRandrot},
altough some components are changed or added.
}
\section{Components}{
 The following components are included as list elements:
\describe{
  \item{\code{X}}{Original (non-transformed) design matrix.}
  \item{\code{Xhe}, \code{Xhe.Y.w}, \code{Yd}}{Pre-multiplied matrix products needed for generation of rotated data (\code{\link[randRotation:randrot]{randrot}}).}
  \item{\code{coef.h}, \code{coef.d}}{Indices of \eqn{H_0}{H0} coefficients (\code{coef.h} or "hypothesis coefficients") and indices of all other coefficients (\code{coef.d} or "determined coefficients").}
  \item{\code{cormat}}{Correlation matrix, see \code{\link[randRotation:initRandrot]{initRandrot}}.}
  \item{\code{tcholC}}{Cholesky decomposition of cormat: \code{cormat = crossprod(tcholC)}.}
  \item{\code{rank}}{Rank of the qr decomposition of (transformed/whitened) \code{X}}
}


The following components are changed or added in \code{initRandrotW-class}
as compared to \code{initRandrot-class}:
\describe{
  \item{\code{decomp.list}}{List containing \code{Xd}, \code{Xhe} and rank of the transformed/whitened design matrix for each feature, see also \code{\link[randRotation:X_decomp]{X_decomp}}.}
  \item{\code{w}}{Numeric matrix with dimensions \code{features x samples} containing component wise square root of the weight matrix, see \code{\link[randRotation:initRandrot]{initRandrot}}.}
}
}

\author{
Peter Hettegger
}
