% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randRot.R
\name{contrastModel}
\alias{contrastModel}
\title{Create transformed model matrix for contrast rotation}
\usage{
contrastModel(X, C, coef.h = seq_len(ncol(C)))
}
\arguments{
\item{X}{\code{(numeric)} model matrix with dimensions
\code{samples x coefficients}.}

\item{C}{\code{(numeric)} contrast matrix with dimensions
\code{coefficients x contrasts}. The contrast matrix must have full column rank.}

\item{coef.h}{column numbers of contrasts (in \code{C}) which should be set
as \code{coef.h} in the transformed model, see
\code{\link[randRotation:initRandrot]{initRandrot}}. All columns are set as
\code{coef.h} by default.}
}
\value{
A transformed model matrix with \code{coef.h} set as attribute.
}
\description{
This function takes a model matrix \code{X} and a contrast matrix \code{C}
and creates a transformed model matrix corresponding to a transformed set
of coefficients.
}
\details{
The last n coefficients of the transformed model matrix correspond to the n
contrasts. By default, all contrasts are set as \code{coef.h}.
See package vignette for examples of data rotations with contrasts.
}
\examples{

group <- c("A", "A", "B", "B")
X <- model.matrix(~0+group)
C <- cbind(contrast1 = c(1, -1))
X2 <- contrastModel(X, C)
}
\author{
Peter Hettegger
}
