% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_AEI.R
\name{get_overlapping_snps}
\alias{get_overlapping_snps}
\title{Retrieve SNPs overlapping intervals}
\usage{
get_overlapping_snps(gr, snpDb, output_file = NULL)
}
\arguments{
\item{gr}{Intervals to query}

\item{snpDb}{A reference ot a SNPlocs database}

\item{output_file}{A path to an output file. If supplied the file can be
optionally compressed by including a ".gz" suffix. If not supplied, SNPS
will be returned as a \link[GenomicRanges:GPos-class]{GenomicRanges::GPos} object}
}
\value{
GPos object containing SNPs overlapping supplied genomic intervals
}
\description{
This function will find SNPs overlapping supplied intervals
using a SNPlocs package. The SNPs can be returned in memory (as GPos
objects) or written to disk as a bed-file (optionally compressed).
}
\examples{
if (require(SNPlocs.Hsapiens.dbSNP144.GRCh38)) {
    gr <- GRanges(rep("22", 10),
        IRanges(seq(10510077, 10610077, by = 1000)[1:10], width = 250),
        strand = "+"
    )
    get_overlapping_snps(gr, SNPlocs.Hsapiens.dbSNP144.GRCh38)
}
}
