% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All_Methods.R
\name{orthBase}
\alias{orthBase}
\title{Generate a orthonormal matrix}
\usage{
orthBase(lin = NULL, col, seqtype = "AA", mask = c(2, 1, 2), seed = NULL)
}
\arguments{
\item{lin}{Number of rows in the desired matrix.}

\item{col}{Number of columns in the desired matrix, which means projection size (psz)}

\item{seqtype}{type of data: AA for amino acid, NT for nucleotide. Parameter required if a mask is provided. The default is ´AA´}

\item{mask}{reading mask. Use this option or `lin' option. Default c(2,1,2).}

\item{seed}{provide, if necessary, a seed to generate the matrix. The default is 647474747}
}
\value{
An orthonormal matrix (basis) whose dimensions correspond to the given mask
        to be used and a desired projection size (length of the output vector). 
        The basis must be supplied to the function \link{SWeeP} (see examples).

        `orthBase' returns a `list` containing:
\itemize{
         \item mat: the orthonormal matrix (basis)
         \item seed: the random seed (metadata to identify the matrix)
         \item version: the rSWeeP version
        }
}
\description{
Generate a orthonormal matrix for specified parameters for ´SWeeP´ function
}
\examples{

# define the mask - determines the length of input vector (20^4 = 160000)
mask <- c(2,1,2) 

# define the length of output vector
psz <- 600

# get the basis matrix to projection
Mybase <- orthBase(mask = mask, col = psz,seqtype='AA')

}
\seealso{
\code{\link{SWeeP}}
}
\author{
Camila P. Perico
}
