% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracks.R
\name{track_spacer}
\alias{track_spacer}
\title{Generate spacing track}
\usage{
track_spacer(title = NULL, height = 2, overlay_previous = "no")
}
\arguments{
\item{title}{String. If specificed, the title of the track to be displayed.}

\item{height}{Numeric. The height of the plotted track in cm. Default is 2.
See notes.}

\item{overlay_previous}{String. Options are "no" (default) or "yes" or
"share-y".}
}
\value{
None
}
\description{
Create spacing track with custom height.
}
\examples{
bed12_dir <- system.file("extdata", "dm3_genes.bed.gz",
  package = "rGenomeTracks"
)
bed4_dir <- system.file("extdata", "dm3_genes.bed4.gz",
  package = "rGenomeTracks"
)
bed6_dir <- system.file("extdata", "dm3_genes.bed6.gz",
  package = "rGenomeTracks"
)

# Create bed track using bed4 file
bed4 <- track_bed(
  file = bed4_dir, height = 3, title = "bed4", color = "cyan", ,
  border_color = "#9ACD32", line_width = 1.5
)

# Create bed track using bed6 file
bed6 <- track_bed(
  file = bed6_dir, height = 3, title = "bed4", fontsize = 8, color = "red",
  border_color = "yellow", arrowhead_included = TRUE
)

# Create bed track using bed12 file
bed12 <- track_bed(
  file = bed12_dir, height = 3, title = "bed12", style = "UCSC",
  arrow_interval = 10, fontsize = 10
)

# Create a spacer track
space <- track_spacer(height = 1)
\dontrun{
# Plotting the tracks
plot_gtracks(bed4 + space + bed6 + space + bed12 + space,
  chr = "X", start = 300 * 10^4, end = 330 * 10^4, verbose = TRUE
)
}
}
\author{
Omar Elashkar
}
