% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeblastdb.R
\name{makeblastdb}
\alias{makeblastdb}
\title{Create BLAST Databases}
\usage{
makeblastdb(
  file,
  db_name = NULL,
  dbtype = "nucl",
  hash_index = TRUE,
  args = "",
  verbose = TRUE
)
}
\arguments{
\item{file}{input file/database name. \strong{Note} that the filename and path
cannot contain whitespaces.}

\item{db_name}{name of the database (files).}

\item{dbtype}{molecule type of target db (\code{"nucl"} or \code{"prot"}).}

\item{hash_index}{logical; create index of sequence hash values.}

\item{args}{string including additional arguments passed on
to \code{makeblastdb}.}

\item{verbose}{logical; show the progress report produced by \code{makeblastdb}?}
}
\value{
Nothing but creates a BLAST database directory.
}
\description{
Call the \code{makeblastdb} utility to create a BLAST database from a FASTA file.
}
\details{
R needs to be able to find the executable (mostly an issue with Windows).
Try \code{Sys.which("makeblastdb")} to see if the program is properly
installed.

Use \code{blast_help("makeblastdb")} to see all possible extra arguments.
Arguments need to be formated in exactly the way as they would be used for
the command line tool.
}
\examples{
## check if makeblastdb is correctly installed
Sys.which("makeblastdb")

## only run if blast is installed
if (has_blast()) {
    ## see possible arguments
    blast_help("makeblastdb")

    ## read some example sequences
    seq <- readRNAStringSet(system.file("examples/RNA_example.fasta",
        package = "rBLAST"
    ))

    ## 1. write the FASTA file
    writeXStringSet(seq, filepath = "seqs.fasta")

    ## 2. make database
    makeblastdb(file = "seqs.fasta", db_name = "db/small", dbtype = "nucl")

    ## 3. open database
    db <- blast("db/small")
    db

    ## 4. perform search (first sequence in the db should be a perfect match)
    predict(db, seq[1])

    ## clean up
    unlink("seqs.fasta")
    unlink("db", recursive = TRUE)
}
}
\seealso{
Other blast: 
\code{\link{blast}()},
\code{\link{blast_db_cache}()}
}
\author{
Michael Hahsler
}
\concept{blast}
\keyword{model}
