% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\docType{methods}
\name{qsmoothWeights}
\alias{qsmoothWeights}
\alias{qsmoothWeights,qsmooth-method}
\title{Generic function that returns the qsmooth weights}
\usage{
qsmoothWeights(object)

\S4method{qsmoothWeights}{qsmooth}(object)
}
\arguments{
\item{object}{an object of class \code{qsmooth}.}
}
\value{
The weights calculated for each feature 
after applying smoothed quantile normalization.
}
\description{
Given a qsmooth object, this function returns the 
qsmooth weights

Accessors for the 'qsmoothWeights' slot of a qsmooth object.
}
\examples{
dat <- cbind(matrix(rnorm(1000), nrow=100, ncol=10), 
             matrix(rnorm(1000, .1, .7), nrow=100, ncol=10))
dat_qs <- qsmooth(object = dat, 
                  group_factor = rep(c(0,1), each=10))
qsmoothWeights(dat_qs)

}
