% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeFeatures-functions.R
\name{removeMiss}
\alias{removeMiss}
\title{Feature filtering based on proportions of missing values}
\usage{
removeMiss(x, group, levels = NULL, cut = 0.7)
}
\arguments{
\item{x}{A matrix-like object.}

\item{group}{A character vector for the information about each sample's
group.}

\item{levels}{A string or character vector specifying one or more groups for
filter filtering based on missing values. If \code{NULL}, all group
levels in \code{group} will be used.}

\item{cut}{A numeric value between 0 and 1 specifying a minimum proportion
of non-missing values to retain a feature.}
}
\value{
A matrix containing the filtered features.
}
\description{
Removes Features based on proportions of missing values in the matrix where
rows represent features and columns represent samples. Features can be
removed based on missing values within a specific group or multiple groups.
A feature will be retained, if there is at least one group with a proportion
of non-missing values above a cut-off.
}
\examples{

data(faahko_se)
m <- assay(faahko_se, "raw")
g <- colData(faahko_se)$sample_group
table(g)

## Filter based on missing values in "KO" and "WT" groups
removeMiss(m, group = g, cut = 0.9)

## Consider only "KO" group (can be useful for QC-based filtering)
removeMiss(m, group = g, levels = "KO", cut = 0.9)

}
\seealso{
See \link{removeFeatures} that provides a
\linkS4class{SummarizedExperiment}-friendly wrapper for this function.
}
