% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowScaling.R
\name{rowScaling}
\alias{rowScaling}
\title{Normalization by scaling peptide/protein intensity across all samples}
\usage{
rowScaling(MSnSetObj, scalingFunction)
}
\arguments{
\item{MSnSetObj}{MSnSet; an object of class MSnSet}

\item{scalingFunction}{function; median or mean}
}
\value{
An object of class \code{MSnSet} (see \code{\link{MSnSet-class}}).
}
\description{
Divide each peptide/protein by the row mean/median and transform to log2
}
\examples{

data(human_anno)
data(exp3_OHT_ESR1)
MSnSet_data <- convertToMSnset(exp3_OHT_ESR1$intensities_qPLEX1, 
                               metadata=exp3_OHT_ESR1$metadata_qPLEX1,
                               indExpData=c(7:16), 
                               Sequences=2, 
                               Accessions=6)
MSnset_norm <- rowScaling(MSnSet_data, scalingFunction=median)

}
