% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups.R
\name{setOperation}
\alias{setOperation}
\title{Perform set operations on selected groups}
\usage{
setOperation(
  operation,
  groups,
  selected,
  symbol = " ",
  groupName = NULL,
  first = NULL,
  second = NULL,
  matches = NULL,
  type = "Samples",
  assignColoursToGroups = FALSE
)
}
\arguments{
\item{operation}{Character: set operation}

\item{groups}{Matrix: groups}

\item{selected}{Integer: index of rows regarding selected groups}

\item{symbol}{Character: Unicode symbol to visually indicate the operation
performed}

\item{groupName}{Character: group name (automatically created if \code{NULL}
or \code{""})}

\item{first}{Character: identifiers of the first element (required when
performing the \code{complement} operation)}

\item{second}{Character: identifiers of the second element (required when
performing the \code{complement} operation)}

\item{matches}{Character: match between samples (as names) and subjects (as
values)}

\item{type}{Character: type of group where set operations are to be performed}

\item{assignColoursToGroups}{Boolean: assign colours to new groups?}
}
\value{
Matrix containing groups (new group is in the first row)
}
\description{
Perform set operations on selected groups
}
\keyword{internal}
