% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_information.R
\name{queryEnsembl}
\alias{queryEnsembl}
\title{Query the Ensembl REST API}
\usage{
queryEnsembl(path, query, grch37 = TRUE)
}
\arguments{
\item{path}{Character: API path}

\item{query}{Character: API query}

\item{grch37}{Boolean: query the Ensembl GRCh37 API? if \code{FALSE}, query
the most recent API}
}
\value{
Parsed response or \code{NULL} if no response
}
\description{
Query the Ensembl REST API
}
\examples{
path  <- "overlap/region/human/7:140424943-140624564"
query <- list(feature = "gene")
psichomics:::queryEnsembl(path, query, grch37 = TRUE)

path  <- "lookup/symbol/human/BRCA2"
query <- list(expand=1)
psichomics:::queryEnsembl(path, query, grch37 = TRUE)
}
\keyword{internal}
