% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{psichomics}
\alias{psichomics}
\title{Start graphical interface of psichomics}
\usage{
psichomics(
  ...,
  launch.browser = TRUE,
  shinyproxy = FALSE,
  testData = FALSE,
  cache = getAnnotationHubOption("CACHE")
)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[shiny:runApp]{shiny::runApp}}
  \describe{
    \item{\code{port}}{The TCP port that the application should listen on. If the
\code{port} is not specified, and the \code{shiny.port} option is set (with
\code{options(shiny.port = XX)}), then that port will be used. Otherwise,
use a random port between 3000:8000, excluding ports that are blocked
by Google Chrome for being considered unsafe: 3659, 4045, 5060,
5061, 6000, 6566, 6665:6669 and 6697. Up to twenty random
ports will be tried.}
    \item{\code{host}}{The IPv4 address that the application should listen on. Defaults
to the \code{shiny.host} option, if set, or \code{"127.0.0.1"} if not. See
Details.}
    \item{\code{workerId}}{Can generally be ignored. Exists to help some editions of
Shiny Server Pro route requests to the correct process.}
    \item{\code{quiet}}{Should Shiny status messages be shown? Defaults to FALSE.}
    \item{\code{display.mode}}{The mode in which to display the application. If set to
the value \code{"showcase"}, shows application code and metadata from a
\code{DESCRIPTION} file in the application directory alongside the
application. If set to \code{"normal"}, displays the application normally.
Defaults to \code{"auto"}, which displays the application in the mode given
in its \code{DESCRIPTION} file, if any.}
    \item{\code{test.mode}}{Should the application be launched in test mode? This is
only used for recording or running automated tests. Defaults to the
\code{shiny.testmode} option, or FALSE if the option is not set.}
  }}

\item{launch.browser}{If true, the system's default web browser will be
launched automatically after the app is started. Defaults to true in
interactive sessions only. The value of this parameter can also be a
function to call with the application's URL.}

\item{shinyproxy}{Boolean: prepare visual interface to run in Shinyproxy?}

\item{testData}{Boolean: load with test data}

\item{cache}{Character: path to \code{AnnotationHub} cache (used to load
alternative splicing event annotation)}
}
\value{
\code{NULL} (function is only used to modify the Shiny session's
state or internal variables)
}
\description{
Start graphical interface of psichomics
}
\examples{
\dontrun{
psichomics()
}
}
