% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{groupPerElem}
\alias{groupPerElem}
\title{Assign one group to each element}
\usage{
groupPerElem(groups, elem = NULL, outerGroupName = NA)
}
\arguments{
\item{groups}{List of integers: groups of elements}

\item{elem}{Character: all elements available}

\item{outerGroupName}{Character: name to give to outer group (if \code{NULL},
only show elements matched to their respective groups)}
}
\value{
Character vector where each element corresponds to the group of the
respective element
}
\description{
Assign one group to each element
}
\examples{
groups <- list(1:3, 4:7, 8:10)
names(groups) <- paste("Stage", 1:3)
groupPerElem(groups)
}
\seealso{
Other functions for data grouping: 
\code{\link{createGroupByAttribute}()},
\code{\link{getGeneList}()},
\code{\link{getSampleFromSubject}()},
\code{\link{getSubjectFromSample}()},
\code{\link{plotGroupIndependence}()},
\code{\link{testGroupIndependence}()}
}
\concept{functions for data grouping}
