% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getSubjectFromSample}
\alias{getSubjectFromSample}
\alias{getPatientFromSample}
\title{Get subjects from given samples}
\usage{
getSubjectFromSample(sampleId, patientId = NULL, na = FALSE, sampleInfo = NULL)
}
\arguments{
\item{sampleId}{Character: sample identifiers}

\item{patientId}{Character: subject identifiers to filter by (optional; if a
matrix or data frame is given, its rownames will be used to infer the subject
identifiers)}

\item{na}{Boolean: return \code{NA} for samples with no matching subjects}

\item{sampleInfo}{Data frame or matrix: sample information containing the
sample identifiers as rownames and a column named "Subject ID" with the
respective subject identifiers}
}
\value{
Character: subject identifiers corresponding to the given samples
}
\description{
Get subjects from given samples
}
\examples{
samples <- paste0("GTEX-", c("ABC", "DEF", "GHI", "JKL", "MNO"), "-sample")
getSubjectFromSample(samples)

# Filter returned samples based on available subjects
subjects <- paste0("GTEX-", c("DEF", "MNO"))
getSubjectFromSample(samples, subjects)
}
\seealso{
Other functions for data grouping: 
\code{\link{createGroupByAttribute}()},
\code{\link{getGeneList}()},
\code{\link{getSampleFromSubject}()},
\code{\link{groupPerElem}()},
\code{\link{plotGroupIndependence}()},
\code{\link{testGroupIndependence}()}
}
\concept{functions for data grouping}
